"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadSpecStep = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _state = require("../../../../state");
var _api_definition_input = require("./api_definition_input");
var i18n = _interopRequireWildcard(require("./translations"));
var il8n_ds = _interopRequireWildcard(require("../../../../steps/data_stream_step/translations"));
var _util = require("./util");
var _common = require("../../../../../../../common");
var _generation_error = require("../../generation_error");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UploadSpecStep = exports.UploadSpecStep = /*#__PURE__*/_react.default.memo(({
  integrationSettings,
  connector,
  isFlyoutGenerating,
  showValidation,
  onShowValidation,
  onUpdateValidation,
  onUpdateNeedsGeneration,
  onAnalyzeApiGenerationComplete
}) => {
  var _integrationSettings$;
  const {
    setIntegrationSettings,
    setIsFlyoutGenerating
  } = (0, _state.useActions)();
  const {
    http,
    notifications
  } = (0, _common.useKibana)().services;
  const [successfulGeneration, setSuccessfulGeneration] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(null);
  const [dataStreamTitle, setDataStreamTitle] = (0, _react.useState)((_integrationSettings$ = integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.dataStreamTitle) !== null && _integrationSettings$ !== void 0 ? _integrationSettings$ : '');
  const [fieldValidationErrors, setFieldValidationErrors] = (0, _react.useState)({
    title: dataStreamTitle === '',
    specFile: true
  });
  const onChangeDataStreamTitle = (0, _react.useCallback)(e => {
    const nextDataStreamTitle = e.target.value;
    setDataStreamTitle(nextDataStreamTitle);
    setIntegrationSettings({
      ...integrationSettings,
      dataStreamTitle: nextDataStreamTitle
    });
    const isMissing = nextDataStreamTitle === undefined || nextDataStreamTitle === '';
    setFieldValidationErrors(current => ({
      ...current,
      title: isMissing
    }));
    setSuccessfulGeneration(false);
  }, [setIntegrationSettings, integrationSettings]);
  (0, _react.useEffect)(() => {
    onUpdateValidation(!fieldValidationErrors.title && !fieldValidationErrors.specFile);
  }, [fieldValidationErrors, onUpdateValidation]);
  const onModifySpecFile = (0, _react.useCallback)(hasValidFile => {
    setFieldValidationErrors(current => ({
      ...current,
      specFile: !hasValidFile
    }));
    setSuccessfulGeneration(false);
  }, []);
  const onAnalyze = (0, _react.useCallback)(() => {
    if (fieldValidationErrors.title || fieldValidationErrors.specFile) {
      onShowValidation();
      return;
    }
    if (http == null || connector == null || integrationSettings == null || (notifications === null || notifications === void 0 ? void 0 : notifications.toasts) == null) {
      return;
    }
    setError(null);
    onUpdateNeedsGeneration(false);
    const abortController = new AbortController();
    const deps = {
      http,
      abortSignal: abortController.signal
    };
    (async () => {
      try {
        setIsFlyoutGenerating(true);
        const apiOptions = (0, _util.getApiPathsWithDescriptions)(integrationSettings.apiSpec);
        const analyzeApiRequest = {
          dataStreamTitle,
          pathOptions: apiOptions,
          connectorId: connector.id,
          langSmithOptions: (0, _common.getLangSmithOptions)()
        };
        const apiAnalysisGraphResult = await (0, _common.runAnalyzeApiGraph)(analyzeApiRequest, deps);
        if (abortController.signal.aborted) return;
        if ((0, _fp.isEmpty)(apiAnalysisGraphResult === null || apiAnalysisGraphResult === void 0 ? void 0 : apiAnalysisGraphResult.results)) {
          throw new Error('Results not found in response');
        }
        const result = apiAnalysisGraphResult.results.suggestedPaths;
        onAnalyzeApiGenerationComplete(result);
        setSuccessfulGeneration(true);
      } catch (e) {
        if (abortController.signal.aborted) return;
        const errorMessage = `${e.message}${e.body ? ` (${e.body.statusCode}): ${e.body.message}` : ''}`;
        setError(errorMessage);
        onUpdateValidation(!!errorMessage);
        onUpdateNeedsGeneration(true);
      } finally {
        setIsFlyoutGenerating(false);
      }
    })();
    return () => {
      abortController.abort();
    };
  }, [fieldValidationErrors.title, fieldValidationErrors.specFile, http, connector, integrationSettings, notifications === null || notifications === void 0 ? void 0 : notifications.toasts, onUpdateNeedsGeneration, onShowValidation, setIsFlyoutGenerating, dataStreamTitle, onAnalyzeApiGenerationComplete, onUpdateValidation]);
  const onCancel = (0, _react.useCallback)(() => {
    setIsFlyoutGenerating(false); // aborts generation
    onUpdateNeedsGeneration(true);
  }, [onUpdateNeedsGeneration, setIsFlyoutGenerating]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    "data-test-subj": "uploadSpecStep"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTimeline, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTimelineItem, {
    verticalAlign: "top",
    icon: 'dot'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isDisabled: isFlyoutGenerating,
    label: il8n_ds.DATA_STREAM_TITLE_LABEL,
    isInvalid: showValidation && fieldValidationErrors.title,
    error: i18n.DATASTREAM_TITLE_REQUIRED
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: "dataStreamTitle",
    "data-test-subj": "dataStreamTitleInput",
    isInvalid: showValidation && fieldValidationErrors.title,
    value: dataStreamTitle,
    onChange: onChangeDataStreamTitle
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTimelineItem, {
    verticalAlign: "top",
    icon: 'dot'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_api_definition_input.ApiDefinitionInput, {
    integrationSettings: integrationSettings,
    isGenerating: isFlyoutGenerating,
    showValidation: showValidation,
    onModifySpecFile: onModifySpecFile
  }), successfulGeneration ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.SUCCESS,
    color: "success",
    iconType: "check",
    "data-test-subj": "successCallout"
  }) : error ? /*#__PURE__*/_react.default.createElement(_generation_error.GenerationError, {
    title: i18n.GENERATION_ERROR,
    error: error,
    retryAction: onAnalyze
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    fullWidth: false,
    isDisabled: isFlyoutGenerating || showValidation && (fieldValidationErrors.title || fieldValidationErrors.specFile),
    isLoading: isFlyoutGenerating,
    color: "primary",
    onClick: onAnalyze,
    "data-test-subj": "analyzeApiButton"
  }, isFlyoutGenerating ? i18n.ANALYZING : i18n.ANALYZE), isFlyoutGenerating && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    flush: "left",
    "data-test-subj": "cancelAnalyzeApiButton"
  }, i18n.CANCEL))))))));
});
UploadSpecStep.displayName = 'UploadSpecStep';