"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceMapRouteRepository = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var t = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/observability-plugin/common");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _license_check = require("../../../common/license_check");
var _utils = require("../../../common/service_map/utils");
var _feature = require("../../feature");
var _transactions = require("../../lib/helpers/transactions");
var _get_ml_client = require("../../lib/helpers/get_ml_client");
var _get_service_map = require("./get_service_map");
var _get_service_map_dependency_node_info = require("./get_service_map_dependency_node_info");
var _get_service_map_service_node_info = require("./get_service_map_service_node_info");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _default_api_types = require("../default_api_types");
var _get_service_group = require("../service_groups/get_service_group");
var _comparison_rt = require("../../../common/comparison_rt");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serviceMapRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/service-map',
  params: t.type({
    query: t.intersection([t.partial({
      serviceName: t.string,
      serviceGroup: t.string,
      kuery: _default_api_types.kueryRt.props.kuery,
      useV2: _ioTsUtils.toBooleanRt
    }), _default_api_types.environmentRt, _default_api_types.rangeRt])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      config,
      context,
      params,
      logger
    } = resources;
    if (!config.serviceMapEnabled) {
      throw _boom.default.notFound();
    }
    const licensingContext = await context.licensing;
    if (!(0, _license_check.isActivePlatinumLicense)(licensingContext.license)) {
      throw _boom.default.forbidden(_utils.invalidLicenseMessage);
    }
    (0, _feature.notifyFeatureUsage)({
      licensingPlugin: licensingContext,
      featureName: 'serviceMaps'
    });
    const {
      query: {
        serviceName,
        serviceGroup: serviceGroupId,
        environment,
        start,
        end,
        kuery,
        useV2
      }
    } = params;
    const {
      savedObjects: {
        client: savedObjectsClient
      },
      uiSettings: {
        client: uiSettingsClient
      }
    } = await context.core;
    const [mlClient, apmEventClient, serviceGroup, maxNumberOfServices] = await Promise.all([(0, _get_ml_client.getMlClient)(resources), (0, _get_apm_event_client.getApmEventClient)(resources), serviceGroupId ? (0, _get_service_group.getServiceGroup)({
      savedObjectsClient,
      serviceGroupId
    }) : Promise.resolve(null), uiSettingsClient.get(_common.apmServiceGroupMaxNumberOfServices)]);
    const searchAggregatedTransactions = await (0, _transactions.getSearchTransactionsEvents)({
      apmEventClient,
      config,
      start,
      end,
      kuery
    });
    return (0, _get_service_map.getServiceMap)({
      mlClient,
      config,
      apmEventClient,
      serviceName,
      environment,
      searchAggregatedTransactions,
      logger: logger.get('serviceMap'),
      start,
      end,
      maxNumberOfServices,
      serviceGroupKuery: serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.kuery,
      kuery,
      useV2
    });
  }
});
const serviceMapServiceNodeRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/service-map/service/{serviceName}',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.rangeRt, _comparison_rt.offsetRt])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      config,
      context,
      params
    } = resources;
    if (!config.serviceMapEnabled) {
      throw _boom.default.notFound();
    }
    const licensingContext = await context.licensing;
    if (!(0, _license_check.isActivePlatinumLicense)(licensingContext.license)) {
      throw _boom.default.forbidden(_utils.invalidLicenseMessage);
    }
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      path: {
        serviceName
      },
      query: {
        environment,
        start,
        end,
        offset
      }
    } = params;
    const searchAggregatedTransactions = await (0, _transactions.getSearchTransactionsEvents)({
      apmEventClient,
      config,
      start,
      end
    });
    return (0, _get_service_map_service_node_info.getServiceMapServiceNodeInfo)({
      environment,
      apmEventClient,
      serviceName,
      searchAggregatedTransactions,
      start,
      end,
      offset
    });
  }
});
const serviceMapDependencyNodeRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/service-map/dependency',
  params: t.type({
    query: t.intersection([t.type({
      dependencyName: t.string
    }), _default_api_types.environmentRt, _default_api_types.rangeRt, _comparison_rt.offsetRt])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      config,
      context,
      params
    } = resources;
    if (!config.serviceMapEnabled) {
      throw _boom.default.notFound();
    }
    const licensingContext = await context.licensing;
    if (!(0, _license_check.isActivePlatinumLicense)(licensingContext.license)) {
      throw _boom.default.forbidden(_utils.invalidLicenseMessage);
    }
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      query: {
        dependencyName,
        environment,
        start,
        end,
        offset
      }
    } = params;
    return (0, _get_service_map_dependency_node_info.getServiceMapDependencyNodeInfo)({
      apmEventClient,
      dependencyName,
      start,
      end,
      environment,
      offset
    });
  }
});
const serviceMapRouteRepository = exports.serviceMapRouteRepository = {
  ...serviceMapRoute,
  ...serviceMapServiceNodeRoute,
  ...serviceMapDependencyNodeRoute
};