"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorMarker = ErrorMarker;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_apm_params = require("../../../../../hooks/use_apm_params");
var _apm = require("../../../../../../common/es_fields/apm");
var _formatters = require("../../../../../../common/utils/formatters");
var _error_detail_link = require("../../../links/apm/error_detail_link");
var _legend = require("../legend");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Popover = _styled.default.div`
  max-width: 280px;
`;
const TimeLegend = (0, _styled.default)(_legend.Legend)`
  margin-bottom: ${({
  theme
}) => theme.euiTheme.size.base};
`;
const ErrorLink = (0, _styled.default)(_error_detail_link.ErrorDetailLink)`
  display: block;
  margin: ${({
  theme
}) => `${theme.euiTheme.size.s} 0 ${theme.euiTheme.size.s} 0`};
  overflow-wrap: break-word;
`;
const Button = (0, _styled.default)(_legend.Legend)`
  height: 20px;
  display: flex;
  align-items: flex-end;
`;

// We chose 240 characters because it fits most error messages and it's still easily readable on a screen.
function truncateMessage(errorMessage) {
  const maxLength = 240;
  if (typeof errorMessage === 'string' && errorMessage.length > maxLength) {
    return errorMessage.substring(0, maxLength) + '…';
  } else {
    return errorMessage;
  }
}
function ErrorMarker({
  mark
}) {
  var _error$trace, _error$trace2, _error$transaction, _error$transaction2, _error$error$log, _error$error$exceptio, _error$error$exceptio2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, showPopover] = (0, _react.useState)(false);
  const {
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/overview', '/services/{serviceName}/errors', '/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/overview', '/mobile-services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/errors-and-crashes', '/traces/explorer/waterfall', '/dependencies/operation');
  const togglePopover = () => showPopover(!isPopoverOpen);
  const button = /*#__PURE__*/_react.default.createElement(Button, {
    "data-test-subj": "popover",
    clickable: true,
    color: euiTheme.colors.danger,
    shape: _legend.Shape.square,
    onClick: togglePopover
  });
  const {
    error
  } = mark;
  const serviceGroup = 'serviceGroup' in query ? query.serviceGroup : '';
  const queryParam = {
    ...query,
    serviceGroup,
    kuery: [...((_error$trace = error.trace) !== null && _error$trace !== void 0 && _error$trace.id ? [`${_apm.TRACE_ID} : "${(_error$trace2 = error.trace) === null || _error$trace2 === void 0 ? void 0 : _error$trace2.id}"`] : []), ...((_error$transaction = error.transaction) !== null && _error$transaction !== void 0 && _error$transaction.id ? [`${_apm.TRANSACTION_ID} : "${(_error$transaction2 = error.transaction) === null || _error$transaction2 === void 0 ? void 0 : _error$transaction2.id}"`] : [])].join(' and ')
  };
  const errorMessage = ((_error$error$log = error.error.log) === null || _error$error$log === void 0 ? void 0 : _error$error$log.message) || ((_error$error$exceptio = error.error.exception) === null || _error$error$exceptio === void 0 ? void 0 : (_error$error$exceptio2 = _error$error$exceptio[0]) === null || _error$error$exceptio2 === void 0 ? void 0 : _error$error$exceptio2.message);
  const truncatedErrorMessage = truncateMessage(errorMessage);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "popover",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: togglePopover,
    anchorPosition: "upCenter"
  }, /*#__PURE__*/_react.default.createElement(Popover, null, /*#__PURE__*/_react.default.createElement(TimeLegend, {
    text: (0, _formatters.asDuration)(mark.offset),
    indicator: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        marginRight: euiTheme.size.xs
      }
    }, "@")
  }), /*#__PURE__*/_react.default.createElement(_legend.Legend, {
    key: mark.serviceColor,
    color: mark.serviceColor,
    text: error.service.name,
    indicator: /*#__PURE__*/_react.default.createElement("span", null)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(ErrorLink, {
    "data-test-subj": "errorLink",
    serviceName: error.service.name,
    errorGroupId: error.error.grouping_key,
    query: queryParam,
    title: errorMessage
  }, truncatedErrorMessage))));
}