"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticsIndexPatternSettings = DiagnosticsIndexPatternSettings;
exports.getIsIndexPatternTabOk = getIsIndexPatternTabOk;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_diagnostics = require("./context/use_diagnostics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DiagnosticsIndexPatternSettings() {
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    diagnosticsBundle,
    status
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  if (status === _use_fetcher.FETCH_STATUS.LOADING) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
      size: "m"
    });
  }
  const indexTemplatesByIndexPattern = diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : diagnosticsBundle.indexTemplatesByIndexPattern;
  if (!indexTemplatesByIndexPattern || (indexTemplatesByIndexPattern === null || indexTemplatesByIndexPattern === void 0 ? void 0 : indexTemplatesByIndexPattern.length) === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, "No settings to display");
  }
  const elms = indexTemplatesByIndexPattern.map(({
    indexPattern,
    indexTemplates
  }) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: indexPattern
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, indexPattern)), !(indexTemplates !== null && indexTemplates !== void 0 && indexTemplates.length) && /*#__PURE__*/_react.default.createElement("em", null, "No matching index templates"), indexTemplates === null || indexTemplates === void 0 ? void 0 : indexTemplates.map(({
      templateName,
      templateIndexPatterns,
      priority,
      isNonStandard
    }) => {
      const text = priority ? `(Priority: ${priority})` : isNonStandard ? `(legacy template)` : '';
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        key: templateName,
        content: `${templateIndexPatterns.join(', ')} ${text}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: isNonStandard ? 'warning' : 'hollow',
        css: {
          marginRight: '5px',
          marginTop: '5px'
        },
        tabIndex: 0
      }, templateName));
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, "This section lists the index patterns specified in", ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmMatchingIndexTemplatesSeeDetailsLink",
    href: router.link('/settings/apm-indices')
  }, "APM Index Settings"), ' ', "and which index templates they match. The priority and index pattern of each index template can be seen by hovering over the item."), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), elms);
}
function getIsIndexPatternTabOk(diagnosticsBundle) {
  if (!diagnosticsBundle) {
    return true;
  }
  const hasError = diagnosticsBundle.indexTemplatesByIndexPattern.some(({
    indexTemplates
  }) => indexTemplates.some(({
    isNonStandard
  }) => isNonStandard));
  return !hasError;
}