"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.investigationGuideSchema = exports.dashboardsSchema = exports.artifactsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const investigationGuideSchema = exports.investigationGuideSchema = _configSchema.schema.object({
  blob: _configSchema.schema.string()
});
const dashboardsSchema = exports.dashboardsSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  id: _configSchema.schema.string()
}));
const artifactsSchema = exports.artifactsSchema = _configSchema.schema.object({
  dashboards: _configSchema.schema.maybe(dashboardsSchema),
  investigation_guide: _configSchema.schema.maybe(investigationGuideSchema)
});