"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.components = void 0;
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _semantic_colors = require("./colors/_semantic_colors");
var _colors_dark = require("./colors/_colors_dark");
var _colors_light = require("./colors/_colors_light");
var _buttons = require("./_buttons");
var _forms = require("./_forms");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var component_colors = {
  badgeBackground: (0, _euiThemeCommon.computed)(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 1),
      backgroundLightText = _ref2[0];
    return backgroundLightText;
  }, ['colors.backgroundLightText']),
  badgeBackgroundSubdued: (0, _euiThemeCommon.computed)(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 1),
      backgroundLightText = _ref4[0];
    return backgroundLightText;
  }, ['colors.backgroundLightText']),
  badgeBorderColorHollow: (0, _euiThemeCommon.computed)(function (_ref5) {
    var _ref6 = _slicedToArray(_ref5, 1),
      borderBasePlain = _ref6[0];
    return borderBasePlain;
  }, ['colors.borderBasePlain']),
  badgeIconButtonBackgroundHover: (0, _euiThemeCommon.computed)(function (_ref7) {
    var _ref8 = _slicedToArray(_ref7, 1),
      backgroundBaseInteractiveHover = _ref8[0];
    return backgroundBaseInteractiveHover;
  }, ['colors.backgroundBaseInteractiveHover']),
  breadcrumbsApplicationBackground: (0, _euiThemeCommon.computed)(function (_ref9) {
    var _ref10 = _slicedToArray(_ref9, 1),
      backgroundLightText = _ref10[0];
    return backgroundLightText;
  }, ['colors.backgroundLightText']),
  breadcrumbsApplicationColor: (0, _euiThemeCommon.computed)(function (_ref11) {
    var _ref12 = _slicedToArray(_ref11, 1),
      textSubdued = _ref12[0];
    return textSubdued;
  }, ['colors.textSubdued']),
  bottomBarBackground: _semantic_colors.SEMANTIC_COLORS.plainDark,
  buttonGroupBackgroundDisabledSelected: (0, _euiThemeCommon.computed)(function (_ref13) {
    var _ref14 = _slicedToArray(_ref13, 1),
      backgroundBaseDisabled = _ref14[0];
    return backgroundBaseDisabled;
  }, ['colors.backgroundBaseDisabled']),
  buttonGroupBorderColor: (0, _euiThemeCommon.computed)(function (_ref15) {
    var _ref16 = _slicedToArray(_ref15, 1),
      borderBasePlain = _ref16[0];
    return borderBasePlain;
  }, ['colors.borderBasePlain']),
  buttonGroupBorderColorSelected: (0, _euiThemeCommon.computed)(function (_ref17) {
    var _ref18 = _slicedToArray(_ref17, 1),
      borderBasePlain = _ref18[0];
    return borderBasePlain;
  }, ['colors.borderBasePlain']),
  buttonGroupFocusColor: _semantic_colors.SEMANTIC_COLORS.plainDark,
  codeBackground: (0, _euiThemeCommon.computed)(function (_ref19) {
    var _ref20 = _slicedToArray(_ref19, 1),
      backgroundBaseHighlighted = _ref20[0];
    return backgroundBaseHighlighted;
  }, ['colors.backgroundBaseHighlighted']),
  codeBackgroundSelected: 'inherit',
  codeColor: (0, _euiThemeCommon.computed)(function (_ref21) {
    var _ref22 = _slicedToArray(_ref21, 1),
      textParagraph = _ref22[0];
    return textParagraph;
  }, ['colors.textParagraph']),
  codeInlineColor: _semantic_colors.SEMANTIC_COLORS.assistance100,
  codeCommentColor: (0, _euiThemeCommon.computed)(function (_ref23) {
    var _ref24 = _slicedToArray(_ref23, 1),
      textSubdued = _ref24[0];
    return textSubdued;
  }, ['colors.textSubdued']),
  codeSelectorColor: 'inherit',
  codeStringColor: _semantic_colors.SEMANTIC_COLORS.accent100,
  codeTagColor: _semantic_colors.SEMANTIC_COLORS.primary100,
  codeNameColor: _semantic_colors.SEMANTIC_COLORS.primary100,
  codeNumberColor: _semantic_colors.SEMANTIC_COLORS.accentSecondary100,
  codeInlineCodeKeywordColor: _semantic_colors.SEMANTIC_COLORS.assistance100,
  codeKeywordColor: _semantic_colors.SEMANTIC_COLORS.primary100,
  codeFunctionTitleColor: 'inherit',
  codeTypeColor: _semantic_colors.SEMANTIC_COLORS.primary100,
  codeAttributeColor: 'inherit',
  codeSymbolColor: _semantic_colors.SEMANTIC_COLORS.danger100,
  codeParamsColor: 'inherit',
  codeMetaColor: (0, _euiThemeCommon.computed)(function (_ref25) {
    var _ref26 = _slicedToArray(_ref25, 1),
      textSubdued = _ref26[0];
    return textSubdued;
  }, ['colors.textSubdued']),
  codeTitleColor: _semantic_colors.SEMANTIC_COLORS.warning100,
  codeSectionColor: _semantic_colors.SEMANTIC_COLORS.danger100,
  codeAdditionColor: _semantic_colors.SEMANTIC_COLORS.accentSecondary100,
  codeDeletionColor: _semantic_colors.SEMANTIC_COLORS.danger100,
  codeSelectorClassColor: 'inherit',
  codeSelectorIdColor: 'inherit',
  collapsibleNavGroupBackground: (0, _euiThemeCommon.computed)(function (_ref27) {
    var _ref28 = _slicedToArray(_ref27, 1),
      backgroundBaseSubdued = _ref28[0];
    return backgroundBaseSubdued;
  }, ['colors.backgroundBaseSubdued']),
  collapsibleNavGroupBackgroundDark: _colors_dark.dark_background_colors.backgroundBaseSubdued,
  dataGridBorderColor: (0, _euiThemeCommon.computed)(function (_ref29) {
    var _ref30 = _slicedToArray(_ref29, 1),
      borderBaseSubdued = _ref30[0];
    return borderBaseSubdued;
  }, ['colors.borderBaseSubdued']),
  dataGridVerticalLineBorderColor: (0, _euiThemeCommon.computed)(function (_ref31) {
    var _ref32 = _slicedToArray(_ref31, 1),
      borderBaseSubdued = _ref32[0];
    return borderBaseSubdued;
  }, ['colors.borderBaseSubdued']),
  dataGridRowBackground: (0, _euiThemeCommon.computed)(function (_ref33) {
    var _ref34 = _slicedToArray(_ref33, 1),
      backgroundBasePlain = _ref34[0];
    return backgroundBasePlain;
  }, ['colors.backgroundBasePlain']),
  dataGridRowBackgroundHover: (0, _euiThemeCommon.computed)(function (_ref35) {
    var _ref36 = _slicedToArray(_ref35, 1),
      backgroundBaseInteractiveHover = _ref36[0];
    return backgroundBaseInteractiveHover;
  }, ['colors.backgroundBaseInteractiveHover']),
  dataGridRowBackgroundSelect: (0, _euiThemeCommon.computed)(function (_ref37) {
    var _ref38 = _slicedToArray(_ref37, 1),
      backgroundBaseInteractiveSelect = _ref38[0];
    return backgroundBaseInteractiveSelect;
  }, ['colors.backgroundBaseInteractiveSelect']),
  dataGridRowBackgroundSelectHover: (0, _euiThemeCommon.computed)(function (_ref39) {
    var _ref40 = _slicedToArray(_ref39, 1),
      backgroundBaseInteractiveSelectHover = _ref40[0];
    return backgroundBaseInteractiveSelectHover;
  }, ['colors.backgroundBaseInteractiveSelectHover']),
  dataGridRowStripesBackground: (0, _euiThemeCommon.computed)(function (_ref41) {
    var _ref42 = _slicedToArray(_ref41, 1),
      backgroundBasePlain = _ref42[0];
    return backgroundBasePlain;
  }, ['colors.backgroundBasePlain']),
  dataGridRowStripesBackgroundHover: (0, _euiThemeCommon.computed)(function (_ref43) {
    var _ref44 = _slicedToArray(_ref43, 1),
      backgroundBasePlain = _ref44[0];
    return backgroundBasePlain;
  }, ['colors.backgroundBasePlain']),
  dataGridRowStripesBackgroundStriped: (0, _euiThemeCommon.computed)(function (_ref45) {
    var _ref46 = _slicedToArray(_ref45, 1),
      backgroundBaseSubdued = _ref46[0];
    return backgroundBaseSubdued;
  }, ['colors.backgroundBaseSubdued']),
  dataGridRowStripesBackgroundStripedHover: (0, _euiThemeCommon.computed)(function (_ref47) {
    var _ref48 = _slicedToArray(_ref47, 1),
      backgroundBaseSubdued = _ref48[0];
    return backgroundBaseSubdued;
  }, ['colors.backgroundBaseSubdued']),
  dataGridRowStripesBackgroundSelect: (0, _euiThemeCommon.computed)(function (_ref49) {
    var _ref50 = _slicedToArray(_ref49, 1),
      backgroundBaseInteractiveSelect = _ref50[0];
    return backgroundBaseInteractiveSelect;
  }, ['colors.backgroundBaseInteractiveSelect']),
  dataGridRowStripesBackgroundSelectHover: (0, _euiThemeCommon.computed)(function (_ref51) {
    var _ref52 = _slicedToArray(_ref51, 1),
      backgroundBaseInteractiveSelect = _ref52[0];
    return backgroundBaseInteractiveSelect;
  }, ['colors.backgroundBaseInteractiveSelect']),
  dragDropDraggingBackground: (0, _euiThemeCommon.computed)(function (_ref53) {
    var _ref54 = _slicedToArray(_ref53, 1),
      backgroundBaseSuccess = _ref54[0];
    return backgroundBaseSuccess;
  }, ['colors.backgroundBaseSuccess']),
  dragDropDraggingOverBackground: (0, _euiThemeCommon.computed)(function (_ref55) {
    var _ref56 = _slicedToArray(_ref55, 1),
      backgroundLightSuccess = _ref56[0];
    return backgroundLightSuccess;
  }, ['colors.backgroundLightSuccess']),
  filterButtonBadgeBackgroundHover: _semantic_colors.SEMANTIC_COLORS.shade25,
  filterSelectItemBackgroundFocusDisabled: (0, _euiThemeCommon.computed)(function (_ref57) {
    var _ref58 = _slicedToArray(_ref57, 1),
      backgroundBaseDisabled = _ref58[0];
    return backgroundBaseDisabled;
  }, ['colors.backgroundBaseDisabled']),
  flyoutFooterBackground: (0, _euiThemeCommon.computed)(function (_ref59) {
    var _ref60 = _slicedToArray(_ref59, 1),
      backgroundBaseHighlighted = _ref60[0];
    return backgroundBaseHighlighted;
  }, ['colors.backgroundBaseHighlighted']),
  flyoutCloseButtonInsideBackground: (0, _euiThemeCommon.computed)(function (_ref61) {
    var _ref62 = _slicedToArray(_ref61, 1),
      backgroundBasePlain = _ref62[0];
    return backgroundBasePlain;
  }, ['colors.backgroundBasePlain']),
  headerBackground: (0, _euiThemeCommon.computed)(function (_ref63) {
    var _ref64 = _slicedToArray(_ref63, 1),
      backgroundBasePlain = _ref64[0];
    return backgroundBasePlain;
  }, ['colors.backgroundBasePlain']),
  headerDarkBackground: _colors_dark.dark_background_colors.backgroundBasePlain,
  headerDarkSearchBorderColor: _colors_dark.dark_border_colors.borderBasePlain,
  headerDarkSectionItemBackgroundFocus: _colors_dark.dark_background_colors.backgroundBasePrimary,
  keyPadMenuItemBackgroundDisabledSelect: (0, _euiThemeCommon.computed)(function (_ref65) {
    var _ref66 = _slicedToArray(_ref65, 1),
      backgroundBaseDisabled = _ref66[0];
    return backgroundBaseDisabled;
  }, ['colors.backgroundBaseDisabled']),
  listGroupItemBackgroundPrimaryActive: (0, _euiThemeCommon.computed)(function (_ref67) {
    var _ref68 = _slicedToArray(_ref67, 1),
      backgroundBaseInteractiveSelect = _ref68[0];
    return backgroundBaseInteractiveSelect;
  }, ['colors.backgroundBaseInteractiveSelect']),
  listGroupItemBackgroundSubduedActive: (0, _euiThemeCommon.computed)(function (_ref69) {
    var _ref70 = _slicedToArray(_ref69, 1),
      backgroundBaseInteractiveSelect = _ref70[0];
    return backgroundBaseInteractiveSelect;
  }, ['colors.backgroundBaseInteractiveSelect']),
  listGroupItemBackgroundHover: (0, _euiThemeCommon.computed)(function (_ref71) {
    var _ref72 = _slicedToArray(_ref71, 1),
      backgroundBaseInteractiveHover = _ref72[0];
    return backgroundBaseInteractiveHover;
  }, ['colors.backgroundBaseInteractiveHover']),
  listGroupItemBackgroundPrimaryHover: (0, _euiThemeCommon.computed)(function (_ref73) {
    var _ref74 = _slicedToArray(_ref73, 1),
      backgroundBaseInteractiveHover = _ref74[0];
    return backgroundBaseInteractiveHover;
  }, ['colors.backgroundBaseInteractiveHover']),
  // we don't want to inherit overrides (e.g. HCM)
  loadingSpinnerBorder: _colors_light.border_colors.borderBasePlain,
  loadingSpinnerHighlight: (0, _euiThemeCommon.computed)(function (_ref75) {
    var _ref76 = _slicedToArray(_ref75, 1),
      borderStrongPrimary = _ref76[0];
    return borderStrongPrimary;
  }, ['colors.borderStrongPrimary']),
  loadingChartMonoBackground0: _semantic_colors.SEMANTIC_COLORS.shade20,
  loadingChartMonoBackground1: _semantic_colors.SEMANTIC_COLORS.shade30,
  loadingChartMonoBackground2: _semantic_colors.SEMANTIC_COLORS.shade40,
  loadingChartMonoBackground3: _semantic_colors.SEMANTIC_COLORS.shade50,
  markBackground: (0, _euiThemeCommon.computed)(function (_ref77) {
    var _ref78 = _slicedToArray(_ref77, 1),
      backgroundLightPrimary = _ref78[0];
    return backgroundLightPrimary;
  }, ['colors.backgroundLightPrimary']),
  markdownFormatTableBorderColor: (0, _euiThemeCommon.computed)(function (_ref79) {
    var _ref80 = _slicedToArray(_ref79, 1),
      borderBasePlain = _ref80[0];
    return borderBasePlain;
  }, ['colors.borderBasePlain']),
  overlayMaskBackground: (0, _euiThemeCommon.computed)(function (_ref81) {
    var _ref82 = _slicedToArray(_ref81, 1),
      backgroundBaseInteractiveOverlay = _ref82[0];
    return backgroundBaseInteractiveOverlay;
  }, ['colors.backgroundBaseInteractiveOverlay']),
  overlayMaskBackgroundHighContrast: "rgba(".concat(_semantic_colors.SEMANTIC_COLORS.shade140RGB, ", 0.9)"),
  popoverPanelBackground: (0, _euiThemeCommon.computed)(function (_ref83) {
    var _ref84 = _slicedToArray(_ref83, 1),
      backgroundBasePlain = _ref84[0];
    return backgroundBasePlain;
  }, ['colors.backgroundBasePlain']),
  popoverFooterBorderColor: (0, _euiThemeCommon.computed)(function (_ref85) {
    var _ref86 = _slicedToArray(_ref85, 1),
      borderBaseSubdued = _ref86[0];
    return borderBaseSubdued;
  }, ['colors.borderBaseSubdued']),
  scrollbarTrackColor: _semantic_colors.SEMANTIC_COLORS.shade15,
  sideNavItemEmphasizedBackground: (0, _euiThemeCommon.computed)(function (_ref87) {
    var _ref88 = _slicedToArray(_ref87, 1),
      backgroundBaseInteractiveSelect = _ref88[0];
    return backgroundBaseInteractiveSelect;
  }, ['colors.backgroundBaseInteractiveSelect']),
  selectableListItemBorderColor: (0, _euiThemeCommon.computed)(function (_ref89) {
    var _ref90 = _slicedToArray(_ref89, 1),
      borderBaseSubdued = _ref90[0];
    return borderBaseSubdued;
  }, ['colors.borderBaseSubdued']),
  skeletonBackgroundSkeletonMiddleHighContrast: "rgba(".concat(_semantic_colors.SEMANTIC_COLORS.shade100RGB, ", 0.04)"),
  superDatePickerBackgroundSuccees: (0, _euiThemeCommon.computed)(function (_ref91) {
    var _ref92 = _slicedToArray(_ref91, 1),
      backgroundBaseSuccess = _ref92[0];
    return backgroundBaseSuccess;
  }, ['colors.backgroundBaseSuccess']),
  switchBackgroundOn: (0, _euiThemeCommon.computed)(function (_ref93) {
    var _ref94 = _slicedToArray(_ref93, 1),
      backgroundFilledPrimary = _ref94[0];
    return backgroundFilledPrimary;
  }, ['colors.backgroundFilledPrimary']),
  switchBackgroundOff: (0, _euiThemeCommon.computed)(function (_ref95) {
    var _ref96 = _slicedToArray(_ref95, 1),
      backgroundFilledText = _ref96[0];
    return backgroundFilledText;
  }, ['colors.backgroundFilledText']),
  switchUncompressedBackgroundDisabled: (0, _euiThemeCommon.computed)(function (_ref97) {
    var _ref98 = _slicedToArray(_ref97, 1),
      backgroundBaseFormsControlDisabled = _ref98[0];
    return backgroundBaseFormsControlDisabled;
  }, ['colors.backgroundBaseFormsControlDisabled']),
  switchCompressedBackgroundDisabled: (0, _euiThemeCommon.computed)(function (_ref99) {
    var _ref100 = _slicedToArray(_ref99, 1),
      backgroundBaseFormsControlDisabled = _ref100[0];
    return backgroundBaseFormsControlDisabled;
  }, ['colors.backgroundBaseFormsControlDisabled']),
  switchMiniBackgroundDisabled: (0, _euiThemeCommon.computed)(function (_ref101) {
    var _ref102 = _slicedToArray(_ref101, 1),
      backgroundBaseFormsControlDisabled = _ref102[0];
    return backgroundBaseFormsControlDisabled;
  }, ['colors.backgroundBaseFormsControlDisabled']),
  switchThumbBackgroundDisabled: (0, _euiThemeCommon.computed)(function (_ref103) {
    var _ref104 = _slicedToArray(_ref103, 1),
      backgroundBasePlain = _ref104[0];
    return backgroundBasePlain;
  }, ['colors.backgroundBasePlain']),
  switchThumbBorderOn: (0, _euiThemeCommon.computed)(function (_ref105) {
    var _ref106 = _slicedToArray(_ref105, 1),
      backgroundFilledPrimary = _ref106[0];
    return backgroundFilledPrimary;
  }, ['colors.backgroundFilledPrimary']),
  switchThumbBorderOff: (0, _euiThemeCommon.computed)(function (_ref107) {
    var _ref108 = _slicedToArray(_ref107, 1),
      backgroundFilledText = _ref108[0];
    return backgroundFilledText;
  }, ['colors.backgroundFilledText']),
  switchIconDisabled: _forms.forms.LIGHT.iconDisabled,
  tableRowBackgroundHover: (0, _euiThemeCommon.computed)(function (_ref109) {
    var _ref110 = _slicedToArray(_ref109, 1),
      backgroundBaseInteractiveHover = _ref110[0];
    return backgroundBaseInteractiveHover;
  }, ['colors.backgroundBaseInteractiveHover']),
  tableRowBackgroundSelected: (0, _euiThemeCommon.computed)(function (_ref111) {
    var _ref112 = _slicedToArray(_ref111, 1),
      backgroundBaseInteractiveSelect = _ref112[0];
    return backgroundBaseInteractiveSelect;
  }, ['colors.backgroundBaseInteractiveSelect']),
  tableRowBackgroundSelectedHover: (0, _euiThemeCommon.computed)(function (_ref113) {
    var _ref114 = _slicedToArray(_ref113, 1),
      backgroundBaseInteractiveSelectHover = _ref114[0];
    return backgroundBaseInteractiveSelectHover;
  }, ['colors.backgroundBaseInteractiveSelectHover']),
  tableRowInteractiveBackgroundHover: (0, _euiThemeCommon.computed)(function (_ref115) {
    var _ref116 = _slicedToArray(_ref115, 1),
      backgroundBaseInteractiveSelect = _ref116[0];
    return backgroundBaseInteractiveSelect;
  }, ['colors.backgroundBaseInteractiveSelect']),
  tableRowInteractiveBackgroundFocus: (0, _euiThemeCommon.computed)(function (_ref117) {
    var _ref118 = _slicedToArray(_ref117, 1),
      backgroundBaseInteractiveHover = _ref118[0];
    return backgroundBaseInteractiveHover;
  }, ['colors.backgroundBaseInteractiveHover']),
  tableCellSortableIconColor: (0, _euiThemeCommon.computed)(function (_ref119) {
    var _ref120 = _slicedToArray(_ref119, 1),
      backgroundFilledText = _ref120[0];
    return backgroundFilledText;
  }, ['colors.backgroundFilledText']),
  tooltipBackground: _colors_dark.dark_background_colors.backgroundBaseSubdued,
  tooltipBorder: _colors_dark.dark_border_colors.borderBaseSubdued,
  tooltipBorderFloating: (0, _euiThemeCommon.computed)(function (_ref121) {
    var _ref122 = _slicedToArray(_ref121, 1),
      borderBaseFloating = _ref122[0];
    return borderBaseFloating;
  }, ['colors.borderBaseFloating']),
  tourFooterBackground: (0, _euiThemeCommon.computed)(function (_ref123) {
    var _ref124 = _slicedToArray(_ref123, 1),
      backgroundBaseHighlighted = _ref124[0];
    return backgroundBaseHighlighted;
  }, ['colors.backgroundBaseHighlighted']),
  treeViewItemBackgroundHover: (0, _euiThemeCommon.computed)(function (_ref125) {
    var _ref126 = _slicedToArray(_ref125, 1),
      backgroundBaseInteractiveHover = _ref126[0];
    return backgroundBaseInteractiveHover;
  }, ['colors.backgroundBaseInteractiveHover'])
};
var components = exports.components = {
  buttons: _buttons.buttons,
  forms: _forms.forms,
  LIGHT: component_colors,
  DARK: _objectSpread(_objectSpread({}, component_colors), {}, {
    buttonGroupFocusColor: _semantic_colors.SEMANTIC_COLORS.plainLight,
    codeInlineColor: _semantic_colors.SEMANTIC_COLORS.assistance60,
    codeStringColor: _semantic_colors.SEMANTIC_COLORS.accent60,
    codeTagColor: _semantic_colors.SEMANTIC_COLORS.primary60,
    codeNameColor: _semantic_colors.SEMANTIC_COLORS.primary60,
    codeNumberColor: _semantic_colors.SEMANTIC_COLORS.accentSecondary60,
    codeInlineCodeKeywordColor: _semantic_colors.SEMANTIC_COLORS.assistance60,
    codeKeywordColor: _semantic_colors.SEMANTIC_COLORS.assistance60,
    codeTypeColor: _semantic_colors.SEMANTIC_COLORS.primary60,
    codeSymbolColor: _semantic_colors.SEMANTIC_COLORS.danger60,
    codeTitleColor: _semantic_colors.SEMANTIC_COLORS.warning60,
    codeSectionColor: _semantic_colors.SEMANTIC_COLORS.danger60,
    codeAdditionColor: _semantic_colors.SEMANTIC_COLORS.accentSecondary60,
    codeDeletionColor: _semantic_colors.SEMANTIC_COLORS.danger60,
    filterButtonBadgeBackgroundHover: _semantic_colors.SEMANTIC_COLORS.shade105,
    loadingSpinnerBorder: _colors_dark.dark_border_colors.borderBasePlain,
    loadingChartMonoBackground0: _semantic_colors.SEMANTIC_COLORS.shade110,
    loadingChartMonoBackground1: _semantic_colors.SEMANTIC_COLORS.shade100,
    loadingChartMonoBackground2: _semantic_colors.SEMANTIC_COLORS.shade90,
    loadingChartMonoBackground3: _semantic_colors.SEMANTIC_COLORS.shade80,
    overlayMaskBackgroundHighContrast: "rgba(".concat(_semantic_colors.SEMANTIC_COLORS.shade140RGB, ", 0.9)"),
    scrollbarTrackColor: _semantic_colors.SEMANTIC_COLORS.shade145,
    skeletonBackgroundSkeletonMiddleHighContrast: "rgba(".concat(_semantic_colors.SEMANTIC_COLORS.plainLightRGB, ", 0.3)"),
    switchIconDisabled: _forms.forms.DARK.iconDisabled,
    // TODO: align table hover states
    tableRowInteractiveBackgroundHover: (0, _euiThemeCommon.computed)(function (_ref127) {
      var _ref128 = _slicedToArray(_ref127, 1),
        backgroundBaseInteractiveHover = _ref128[0];
      return backgroundBaseInteractiveHover;
    }, ['colors.backgroundBaseInteractiveHover']),
    tableRowInteractiveBackgroundFocus: (0, _euiThemeCommon.computed)(function (_ref129) {
      var _ref130 = _slicedToArray(_ref129, 1),
        backgroundBaseInteractiveHover = _ref130[0];
      return backgroundBaseInteractiveHover;
    }, ['colors.backgroundBaseInteractiveHover'])
  })
};