"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScreenReaderLabel = ScreenReaderLabel;
const react_1 = __importDefault(require("react"));
function ScreenReaderLabel({ label, labelHeadingLevel, labelId, goalChartLabels, }) {
    const Heading = labelHeadingLevel;
    if (!label && !goalChartLabels?.majorLabel && !goalChartLabels?.minorLabel)
        return null;
    let unifiedLabel = '';
    if (!label && goalChartLabels?.majorLabel) {
        unifiedLabel = goalChartLabels?.majorLabel;
    }
    else if (label && !goalChartLabels?.majorLabel) {
        unifiedLabel = label;
    }
    else if (label && goalChartLabels?.majorLabel && label !== goalChartLabels?.majorLabel) {
        unifiedLabel = `${label}; Chart visible label: ${goalChartLabels?.majorLabel}`;
    }
    return (react_1.default.createElement(react_1.default.Fragment, null,
        unifiedLabel && react_1.default.createElement(Heading, { id: labelId }, unifiedLabel),
        goalChartLabels?.minorLabel && react_1.default.createElement("p", null, goalChartLabels?.minorLabel)));
}
//# sourceMappingURL=label.js.map