"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSearchEmbeddableDefaults = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _constants = require("../../common/constants");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getSearchEmbeddableDefaults = uiSettings => {
  return {
    rowHeight: uiSettings.get(_discoverUtils.ROW_HEIGHT_OPTION),
    headerRowHeight: _constants2.DEFAULT_HEADER_ROW_HEIGHT_LINES,
    rowsPerPage: (0, _constants.getDefaultRowsPerPage)(uiSettings),
    sampleSize: uiSettings.get(_discoverUtils.SAMPLE_SIZE_SETTING)
  };
};
exports.getSearchEmbeddableDefaults = getSearchEmbeddableDefaults;