"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterIssues = filterIssues;
exports.mapDegradedFieldsIssues = mapDegradedFieldsIssues;
exports.mapFailedDocsIssues = mapFailedDocsIssues;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function filterIssues(data = [], type) {
  return data.filter(field => field.type !== type);
}
function mapDegradedFieldsIssues(degradedFields = []) {
  return degradedFields.map(field => ({
    ...field,
    type: 'degraded'
  }));
}
function mapFailedDocsIssues(failedDocsDetails) {
  return failedDocsDetails.count > 0 ? [{
    ...failedDocsDetails,
    name: 'failedDocs',
    type: 'failed'
  }] : [];
}