"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorCallout = ErrorCallout;
exports.ManualRolloverCallout = ManualRolloverCallout;
exports.MessageCallout = MessageCallout;
exports.SuccessCallout = SuccessCallout;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../../../../../common/translations");
var _hooks = require("../../../../../../hooks");
var _component_template_name = require("../../../../../../../common/utils/component_template_name");
var _utils = require("../../../../../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MessageCallout() {
  const {
    isMitigationInProgress,
    newFieldLimitData,
    isRolloverRequired,
    isMitigationAppliedSuccessfully
  } = (0, _hooks.useQualityIssues)();
  const {
    error: serverError
  } = newFieldLimitData !== null && newFieldLimitData !== void 0 ? newFieldLimitData : {};
  if (serverError) {
    return /*#__PURE__*/_react.default.createElement(ErrorCallout, null);
  }
  if (!isMitigationInProgress && isRolloverRequired) {
    return /*#__PURE__*/_react.default.createElement(ManualRolloverCallout, null);
  }
  if (!isMitigationInProgress && isMitigationAppliedSuccessfully) {
    return /*#__PURE__*/_react.default.createElement(SuccessCallout, null);
  }
  return null;
}
function SuccessCallout() {
  var _locators$get, _dataStreamSettings$i;
  const {
    services: {
      share: {
        url: {
          locators
        }
      }
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    dataStreamSettings,
    datasetDetails
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const {
    name
  } = datasetDetails;
  const componentTemplateUrl = (_locators$get = locators.get('INDEX_MANAGEMENT_LOCATOR_ID')) === null || _locators$get === void 0 ? void 0 : _locators$get.useUrl({
    page: 'component_template',
    componentTemplate: `${(0, _component_template_name.getComponentTemplatePrefixFromIndexTemplate)((_dataStreamSettings$i = dataStreamSettings === null || dataStreamSettings === void 0 ? void 0 : dataStreamSettings.indexTemplate) !== null && _dataStreamSettings$i !== void 0 ? _dataStreamSettings$i : name)}@custom`
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _translations.fieldLimitMitigationSuccessMessage,
    color: "success",
    iconType: "checkInCircleFilled",
    "data-test-subj": "datasetQualityDetailsDegradedFlyoutNewLimitSetSuccessCallout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "datasetQualityDetailsDegradedFlyoutNewLimitSetCheckComponentTemplate",
    href: componentTemplateUrl,
    target: "_blank",
    color: "success"
  }, _translations.fieldLimitMitigationSuccessComponentTemplateLinkText));
}
function ManualRolloverCallout() {
  const {
    triggerRollover,
    isRolloverInProgress
  } = (0, _hooks.useQualityIssues)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _translations.fieldLimitMitigationPartiallyFailedMessage,
    color: "danger",
    iconType: "checkInCircleFilled"
  }, /*#__PURE__*/_react.default.createElement("p", null, _translations.fieldLimitMitigationPartiallyFailedMessageDescription), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "datasetQualityNewLimitSetManualRollover",
    onClick: triggerRollover,
    iconType: "popout",
    size: "s",
    title: _translations.fieldLimitMitigationRolloverButton,
    color: "danger",
    isLoading: isRolloverInProgress
  }, _translations.fieldLimitMitigationRolloverButton));
}
function ErrorCallout() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _translations.fieldLimitMitigationFailedMessage,
    color: "danger",
    iconType: "error",
    "data-test-subj": "datasetQualityDetailsNewFieldLimitErrorCallout"
  }, /*#__PURE__*/_react.default.createElement("p", null, _translations.fieldLimitMitigationFailedMessageDescription));
}