"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = Header;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _translations = require("../../../common/translations");
var _constants = require("../../../common/constants");
var _alert_flyout = require("../../alerts/alert_flyout");
var _get_alerting_capabilities = require("../../alerts/get_alerting_capabilities");
var _hooks = require("../../hooks");
var _utils = require("../../utils");
var _common = require("../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Header() {
  var _integrationDetails$i, _integrationDetails$i2, _integrationDetails$i3, _integrationDetails$i4, _integrationDetails$i5;
  const {
    datasetDetails,
    timeRange,
    integrationDetails,
    loadingState
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const {
    services: {
      application,
      alerting
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    capabilities
  } = application;
  const {
    navigationSources
  } = (0, _hooks.useDatasetDetailsTelemetry)();
  const {
    rawName,
    name: title
  } = datasetDetails;
  const euiShadow = (0, _eui.useEuiShadow)('s');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    sendTelemetry
  } = (0, _hooks.useDatasetDetailsRedirectLinkTelemetry)({
    navigationSource: navigationSources.Header
  });
  const redirectLinkProps = (0, _hooks.useRedirectLink)({
    dataStreamStat: `${datasetDetails.rawName},${datasetDetails.rawName}${_constants.FAILURE_STORE_SELECTOR}`,
    timeRangeConfig: timeRange,
    sendTelemetry
  });
  const {
    isAlertingAvailable
  } = (0, _get_alerting_capabilities.getAlertingCapabilities)(alerting, capabilities);
  const [showPopover, setShowPopover] = (0, _react2.useState)(false);
  const [ruleType, setRuleType] = (0, _react2.useState)(null);
  const pageTitle = (_integrationDetails$i = integrationDetails === null || integrationDetails === void 0 ? void 0 : (_integrationDetails$i2 = integrationDetails.integration) === null || _integrationDetails$i2 === void 0 ? void 0 : (_integrationDetails$i3 = _integrationDetails$i2.integration) === null || _integrationDetails$i3 === void 0 ? void 0 : (_integrationDetails$i4 = _integrationDetails$i3.datasets) === null || _integrationDetails$i4 === void 0 ? void 0 : _integrationDetails$i4[datasetDetails.name]) !== null && _integrationDetails$i !== void 0 ? _integrationDetails$i : title;
  const createMenuItems = [{
    name: _translations.createAlertText,
    icon: 'bell',
    onClick: () => {
      setShowPopover(false);
      setRuleType(_ruleDataUtils.DEGRADED_DOCS_RULE_TYPE_ID);
    },
    'data-test-subj': `createAlert`
  }, {
    name: _translations.openInDiscoverText,
    icon: 'discoverApp',
    ...redirectLinkProps.linkProps,
    'data-test-subj': `openInDiscover`
  }];
  const titleActionButtons = [/*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    key: "actionsPopover",
    isOpen: showPopover,
    closePopover: () => setShowPopover(false),
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      iconSide: "right",
      iconType: "arrowDown",
      "data-test-subj": "datasetQualityDetailsActionsDropdown",
      key: "actionsDropdown",
      onClick: () => setShowPopover(prev => !prev)
    }, _i18n.i18n.translate('xpack.datasetQuality.ActionsLabel', {
      defaultMessage: 'Actions'
    })),
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    "data-test-subj": "autoFollowPatternActionContextMenu",
    panels: [{
      id: 0,
      items: createMenuItems
    }]
  }))];
  return !loadingState.integrationDetailsLoaded ? /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonTitle, {
    size: "s",
    "data-test-subj": "datasetQualityDetailsIntegrationLoading",
    className: "datasetQualityDetailsIntegrationLoading"
  }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "flexStart",
    direction: "column"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "datasetQualityDetailsTitle",
    size: "l"
  }, /*#__PURE__*/_react2.default.createElement("h2", null, pageTitle)), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
                ${euiShadow};
                padding: ${euiTheme.size.xs};
                border-radius: ${euiTheme.size.xxs};
              `
  }, /*#__PURE__*/_react2.default.createElement(_common.IntegrationIcon, {
    integration: integrationDetails === null || integrationDetails === void 0 ? void 0 : (_integrationDetails$i5 = integrationDetails.integration) === null || _integrationDetails$i5 === void 0 ? void 0 : _integrationDetails$i5.integration
  }))), /*#__PURE__*/_react2.default.createElement("p", null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, rawName)))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
            margin-right: ${euiTheme.size.l};
          `,
    gutterSize: "s",
    justifyContent: "flexEnd",
    alignItems: "center"
  }, isAlertingAvailable ? titleActionButtons : /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": "datasetQualityDetailsHeaderButton",
    size: "s"
  }, redirectLinkProps.linkProps, {
    iconType: "discoverApp"
  }), _translations.openInDiscoverText))), /*#__PURE__*/_react2.default.createElement(_alert_flyout.AlertFlyout, {
    dataStream: rawName,
    addFlyoutVisible: !!ruleType,
    setAddFlyoutVisibility: visible => {
      if (!visible) {
        setRuleType(null);
      }
    }
  }));
}