"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFieldLimitResponseRt = exports.qualityIssueRT = exports.qualityIssueBaseRT = exports.integrationRt = exports.integrationIconRt = exports.integrationDashboardsRT = exports.integrationDashboardRT = exports.getPreviewChartResponseRt = exports.getNonAggregatableDatasetsRt = exports.getIntegrationsResponseRt = exports.getDataStreamsTypesPrivilegesResponseRt = exports.getDataStreamsStatsResponseRt = exports.getDataStreamsSettingsResponseRt = exports.getDataStreamsEstimatedDataInBytesResponseRt = exports.getDataStreamsDetailsResponseRt = exports.getDataStreamTotalDocsResponseRt = exports.getDataStreamFailedDocsResponseRt = exports.getDataStreamDegradedFieldsResponseRt = exports.getDataStreamDegradedDocsResponseRt = exports.failedDocsErrorsRt = exports.failedDocsErrorRt = exports.degradedFieldValuesRt = exports.degradedFieldRt = exports.degradedFieldAnalysisRt = exports.dataStreamsEstimatedDataInBytesRT = exports.dataStreamStatRt = exports.dataStreamSettingsRt = exports.dataStreamRolloverResponseRt = exports.dataStreamDocsStatRt = exports.dataStreamDetailsRt = exports.checkAndLoadIntegrationResponseRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const userPrivilegesRt = rt.type({
  canMonitor: rt.boolean,
  canReadFailureStore: rt.boolean
});
const datasetPrivilegeRt = rt.record(rt.string, rt.intersection([userPrivilegesRt, rt.type({
  canRead: rt.boolean
})]));
const datasetUserPrivilegesRt = rt.type({
  datasetsPrivilages: datasetPrivilegeRt,
  canViewIntegrations: rt.boolean
});
const getDataStreamsTypesPrivilegesResponseRt = exports.getDataStreamsTypesPrivilegesResponseRt = rt.exact(rt.type({
  datasetTypesPrivileges: datasetPrivilegeRt
}));
const dataStreamStatRt = exports.dataStreamStatRt = rt.intersection([rt.type({
  name: rt.string,
  userPrivileges: userPrivilegesRt
}), rt.partial({
  size: rt.string,
  sizeBytes: rt.number,
  lastActivity: rt.number,
  integration: rt.string,
  totalDocs: rt.number,
  creationDate: rt.number,
  hasFailureStore: rt.boolean
})]);
const dataStreamDocsStatRt = exports.dataStreamDocsStatRt = rt.type({
  dataset: rt.string,
  count: rt.number
});
const getDataStreamTotalDocsResponseRt = exports.getDataStreamTotalDocsResponseRt = rt.type({
  totalDocs: rt.array(dataStreamDocsStatRt)
});
const getDataStreamDegradedDocsResponseRt = exports.getDataStreamDegradedDocsResponseRt = rt.type({
  degradedDocs: rt.array(dataStreamDocsStatRt)
});
const getDataStreamFailedDocsResponseRt = exports.getDataStreamFailedDocsResponseRt = rt.type({
  failedDocs: rt.array(dataStreamDocsStatRt)
});
const integrationDashboardRT = exports.integrationDashboardRT = rt.type({
  id: rt.string,
  title: rt.string
});
const integrationDashboardsRT = exports.integrationDashboardsRT = rt.type({
  dashboards: rt.array(integrationDashboardRT)
});
const integrationIconRt = exports.integrationIconRt = rt.intersection([rt.type({
  src: rt.string
}), rt.partial({
  path: rt.string,
  size: rt.string,
  title: rt.string,
  type: rt.string
})]);
const integrationRt = exports.integrationRt = rt.intersection([rt.type({
  name: rt.string
}), rt.partial({
  title: rt.string,
  version: rt.string,
  icons: rt.array(integrationIconRt),
  datasets: rt.record(rt.string, rt.string)
})]);
const checkAndLoadIntegrationResponseRt = exports.checkAndLoadIntegrationResponseRt = rt.union([rt.type({
  isIntegration: rt.literal(false),
  areAssetsAvailable: rt.boolean
}), rt.type({
  isIntegration: rt.literal(true),
  areAssetsAvailable: rt.literal(true),
  integration: integrationRt
})]);
const getIntegrationsResponseRt = exports.getIntegrationsResponseRt = rt.exact(rt.type({
  integrations: rt.array(integrationRt)
}));
const qualityIssueBaseRT = exports.qualityIssueBaseRT = rt.type({
  count: rt.number,
  lastOccurrence: rt.union([rt.undefined, rt.null, rt.number]),
  timeSeries: rt.array(rt.type({
    x: rt.number,
    y: rt.number
  }))
});
const qualityIssueRT = exports.qualityIssueRT = rt.intersection([qualityIssueBaseRT, rt.partial({
  indexFieldWasLastPresentIn: rt.string
}), rt.type({
  name: rt.string,
  type: rt.keyof({
    degraded: null,
    failed: null
  })
})]);
const failedDocsErrorRt = exports.failedDocsErrorRt = rt.type({
  message: rt.string,
  type: rt.string
});
const failedDocsErrorsRt = exports.failedDocsErrorsRt = rt.type({
  errors: rt.array(failedDocsErrorRt)
});
const degradedFieldRt = exports.degradedFieldRt = rt.intersection([qualityIssueBaseRT, rt.type({
  name: rt.string,
  indexFieldWasLastPresentIn: rt.string
})]);
const getDataStreamDegradedFieldsResponseRt = exports.getDataStreamDegradedFieldsResponseRt = rt.type({
  degradedFields: rt.array(degradedFieldRt)
});
const degradedFieldValuesRt = exports.degradedFieldValuesRt = rt.type({
  field: rt.string,
  values: rt.array(rt.string)
});
const degradedFieldAnalysisRt = exports.degradedFieldAnalysisRt = rt.intersection([rt.type({
  isFieldLimitIssue: rt.boolean,
  fieldCount: rt.number,
  totalFieldLimit: rt.number
}), rt.partial({
  ignoreMalformed: rt.boolean,
  nestedFieldLimit: rt.number,
  fieldMapping: rt.partial({
    type: rt.string,
    ignore_above: rt.number
  }),
  defaultPipeline: rt.string
})]);
const updateFieldLimitResponseRt = exports.updateFieldLimitResponseRt = rt.intersection([rt.type({
  isComponentTemplateUpdated: rt.union([rt.boolean, rt.undefined]),
  isLatestBackingIndexUpdated: rt.union([rt.boolean, rt.undefined]),
  customComponentTemplateName: rt.string
}), rt.partial({
  error: rt.string
})]);
const dataStreamRolloverResponseRt = exports.dataStreamRolloverResponseRt = rt.type({
  acknowledged: rt.boolean
});
const dataStreamSettingsRt = exports.dataStreamSettingsRt = rt.partial({
  lastBackingIndexName: rt.string,
  indexTemplate: rt.string,
  createdOn: rt.union([rt.null, rt.number]),
  // rt.null is needed because `createdOn` is not available on Serverless
  integration: rt.string,
  datasetUserPrivileges: datasetUserPrivilegesRt
});
const dataStreamDetailsRt = exports.dataStreamDetailsRt = rt.partial({
  hasFailureStore: rt.boolean,
  lastActivity: rt.number,
  degradedDocsCount: rt.number,
  failedDocsCount: rt.number,
  docsCount: rt.number,
  sizeBytes: rt.number,
  services: rt.record(rt.string, rt.array(rt.string)),
  hosts: rt.record(rt.string, rt.array(rt.string)),
  userPrivileges: userPrivilegesRt
});
const getDataStreamsStatsResponseRt = exports.getDataStreamsStatsResponseRt = rt.exact(rt.type({
  datasetUserPrivileges: datasetUserPrivilegesRt,
  dataStreamsStats: rt.array(dataStreamStatRt)
}));
const getDataStreamsSettingsResponseRt = exports.getDataStreamsSettingsResponseRt = rt.exact(dataStreamSettingsRt);
const getDataStreamsDetailsResponseRt = exports.getDataStreamsDetailsResponseRt = rt.exact(dataStreamDetailsRt);
const dataStreamsEstimatedDataInBytesRT = exports.dataStreamsEstimatedDataInBytesRT = rt.type({
  estimatedDataInBytes: rt.number
});
const getDataStreamsEstimatedDataInBytesResponseRt = exports.getDataStreamsEstimatedDataInBytesResponseRt = rt.exact(dataStreamsEstimatedDataInBytesRT);
const getNonAggregatableDatasetsRt = exports.getNonAggregatableDatasetsRt = rt.exact(rt.type({
  aggregatable: rt.boolean,
  datasets: rt.array(rt.string)
}));
const getPreviewChartResponseRt = exports.getPreviewChartResponseRt = rt.type({
  series: rt.array(rt.type({
    name: rt.string,
    data: rt.array(rt.type({
      x: rt.number,
      y: rt.union([rt.number, rt.null])
    }))
  })),
  totalGroups: rt.number
});