"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCreateBreadcrumbs = getCreateBreadcrumbs;
exports.getCreateFieldBreadcrumbs = getCreateFieldBreadcrumbs;
exports.getEditBreadcrumbs = getEditBreadcrumbs;
exports.getEditFieldBreadcrumbs = getEditFieldBreadcrumbs;
exports.getListBreadcrumbs = getListBreadcrumbs;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getListBreadcrumbs(withLink) {
  return [{
    text: _i18n.i18n.translate('indexPatternManagement.dataViews.listBreadcrumb', {
      defaultMessage: 'Data views'
    }),
    href: withLink ? `/` : ''
  }];
}
function getCreateBreadcrumbs(withLink) {
  return [...getListBreadcrumbs(true), {
    text: _i18n.i18n.translate('indexPatternManagement.dataViews.createBreadcrumb', {
      defaultMessage: 'Create data view'
    }),
    href: withLink ? `/create` : ''
  }];
}
function getEditBreadcrumbs(indexPattern, withLink) {
  return [...getListBreadcrumbs(true), {
    text: indexPattern.getName(),
    href: withLink ? `/patterns/${indexPattern.id}` : ''
  }];
}
function getEditFieldBreadcrumbs(indexPattern, fieldName) {
  return [...getEditBreadcrumbs(indexPattern, true), {
    text: fieldName
  }];
}
function getCreateFieldBreadcrumbs(indexPattern) {
  return [...getEditBreadcrumbs(indexPattern, true), {
    text: _i18n.i18n.translate('indexPatternManagement.indexPatterns.createFieldBreadcrumb', {
      defaultMessage: 'Create field'
    })
  }];
}