"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/index-management-plugin/public");
var _eui = require("@elastic/eui");
var _routing = require("../../../../../services/routing");
var _components = require("../../../../../components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DetailPanel extends _react.Component {
  renderAutoFollowPattern({
    followIndexPatternPrefix,
    followIndexPatternSuffix,
    remoteCluster,
    leaderIndexPatterns,
    active
  }) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("section", null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.statusLabel",
      defaultMessage: "Status"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "status"
    }, !active ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.pausedStatus",
      defaultMessage: "Paused"
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "success"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.activeStatus",
      defaultMessage: "Active"
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement("section", {
      "aria-labelledby": "ccrAutoFollowPatternDetailSettingsTitle",
      "data-test-subj": "settingsSection"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", {
      id: "ccrAutoFollowPatternDetailSettingsTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.statusTitle",
      defaultMessage: "Settings"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      "data-test-subj": "settingsValues"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.remoteClusterLabel",
      defaultMessage: "Remote cluster"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteCluster"
    }, remoteCluster))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      "data-test-subj": "settingsValues"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.leaderPatternsLabel",
      defaultMessage: "Leader patterns"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "leaderIndexPatterns"
    }, leaderIndexPatterns.join(', '))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      "data-test-subj": "settingsValues"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.prefixLabel",
      defaultMessage: "Prefix"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "patternPrefix"
    }, followIndexPatternPrefix || /*#__PURE__*/_react.default.createElement("em", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.prefixEmptyValue",
      defaultMessage: "No prefix"
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      "data-test-subj": "settingsValues"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.suffixLabel",
      defaultMessage: "Suffix"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "patternSuffix"
    }, followIndexPatternSuffix || /*#__PURE__*/_react.default.createElement("em", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.suffixEmptyValue",
      defaultMessage: "No suffix"
    }))))))));
  }
  renderIndicesPreview(prefix, suffix, leaderIndexPatterns) {
    return /*#__PURE__*/_react.default.createElement("section", {
      "data-test-subj": "indicesPreviewSection"
    }, /*#__PURE__*/_react.default.createElement(_components.AutoFollowPatternIndicesPreview, {
      prefix: prefix,
      suffix: suffix,
      leaderIndexPatterns: leaderIndexPatterns
    }));
  }
  renderAutoFollowPatternNotFound() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "warning",
      color: "danger"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.notFoundLabel",
      defaultMessage: "Auto-follow pattern not found"
    }))))));
  }
  renderAutoFollowPatternErrors(autoFollowPattern) {
    if (!autoFollowPattern.errors.length) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement("section", {
      "data-test-subj": "errors"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "danger"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      "data-test-subj": "titleErrors"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.recentErrorsTitle",
      defaultMessage: "Recent errors"
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("ul", null, autoFollowPattern.errors.map((error, i) => /*#__PURE__*/_react.default.createElement("li", {
      key: i,
      "data-test-subj": "recentError"
    }, /*#__PURE__*/_react.default.createElement("strong", null, (0, _moment.default)(error.timestamp).format('MMMM Do, YYYY h:mm:ss A')), ":", ' ', error.autoFollowException.reason)))));
  }
  renderFlyoutBody() {
    const {
      autoFollowPattern
    } = this.props;
    if (!autoFollowPattern) {
      return this.renderAutoFollowPatternNotFound();
    }
    const {
      followIndexPatternPrefix,
      followIndexPatternSuffix,
      leaderIndexPatterns
    } = autoFollowPattern;
    let indexManagementFilter;
    if (followIndexPatternPrefix) {
      indexManagementFilter = `name:${followIndexPatternPrefix}`;
    } else if (followIndexPatternSuffix) {
      indexManagementFilter = `name:${followIndexPatternSuffix}`;
    }
    const indexManagementUri = (0, _public.getIndexListUri)(indexManagementFilter);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, this.renderAutoFollowPattern(autoFollowPattern), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), this.renderIndicesPreview(followIndexPatternPrefix, followIndexPatternSuffix, leaderIndexPatterns), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _routing.routing._reactRouter.getUrlForApp('management', {
        path: `data/index_management${indexManagementUri}`
      }),
      "data-test-subj": "viewIndexManagementLink"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.viewIndicesLink",
      defaultMessage: "View your follower indices in Index Management"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), this.renderAutoFollowPatternErrors(autoFollowPattern));
  }
  renderFlyoutFooter() {
    const {
      autoFollowPattern,
      closeDetailPanel
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      flush: "left",
      onClick: closeDetailPanel,
      "data-test-subj": "closeFlyoutButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.closeButtonLabel",
      defaultMessage: "Close"
    }))), autoFollowPattern && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components.AutoFollowPatternActionMenu, {
      edit: true,
      arrowDirection: "up",
      patterns: [autoFollowPattern]
    }))))));
  }
  render() {
    const {
      autoFollowPatternId,
      closeDetailPanel
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      "data-test-subj": "autoFollowPatternDetail",
      onClose: closeDetailPanel,
      "aria-labelledby": "autoFollowPatternDetailsFlyoutTitle",
      size: "m",
      maxWidth: 400
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m",
      id: "autoFollowPatternDetailsFlyoutTitle",
      "data-test-subj": "title"
    }, /*#__PURE__*/_react.default.createElement("h2", null, autoFollowPatternId))), this.renderFlyoutBody(), this.renderFlyoutFooter());
  }
}
exports.DetailPanel = DetailPanel;
(0, _defineProperty2.default)(DetailPanel, "propTypes", {
  apiStatus: _propTypes.default.string,
  autoFollowPatternId: _propTypes.default.string,
  autoFollowPattern: _propTypes.default.object,
  closeDetailPanel: _propTypes.default.func.isRequired
});