"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConvertConnectorModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _convert_connector_logic = require("../../search_index/connector/native_connector_configuration/convert_connector_logic");
var _translations = require("../../connectors/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConvertConnectorModal = () => {
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const {
    convertConnector,
    hideModal
  } = (0, _kea.useActions)((0, _convert_connector_logic.ConvertConnectorLogic)({
    http
  }));
  const {
    isLoading
  } = (0, _kea.useValues)((0, _convert_connector_logic.ConvertConnectorLogic)({
    http
  }));
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    onCancel: () => hideModal(),
    onConfirm: () => convertConnector(),
    title: _i18n.i18n.translate('xpack.contentConnectors.searchApplications.searchApplication.indices.convertInfexConfirm.title', {
      defaultMessage: 'Sure you want to convert your connector?'
    }),
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    buttonColor: "danger",
    cancelButtonText: _translations.CANCEL_BUTTON_LABEL,
    confirmButtonText: _i18n.i18n.translate('xpack.contentConnectors.searchApplications.searchApplication.indices.convertIndexConfirm.text', {
      defaultMessage: 'Yes'
    }),
    isLoading: isLoading,
    defaultFocusedButton: "confirm",
    maxWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.contentConnectors.searchApplications.searchApplication.indices.convertIndexConfirm.description', {
    defaultMessage: "Converting an Elastic managed connector to a self-managed connector can't be undone."
  }))));
};
exports.ConvertConnectorModal = ConvertConnectorModal;