"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NamespaceSelector = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NamespaceSelector = ({
  activeNamespace,
  namespaces,
  onNamespaceChange
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onSelectedNamespaceChange = (0, _react.useCallback)(namespaceKey => {
    if (namespaceKey !== activeNamespace) {
      onNamespaceChange(namespaceKey);
    }
    setIsPopoverOpen(false);
  }, [activeNamespace, onNamespaceChange]);
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(currentVal => !currentVal), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const isSelectedProps = (0, _react.useCallback)(namespace => {
    return namespace === activeNamespace ? {
      icon: 'check',
      'aria-current': true
    } : {
      icon: 'empty',
      'aria-current': undefined
    };
  }, [activeNamespace]);
  const menuItems = (0, _react.useMemo)(() => {
    return namespaces.map((namespace, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: `namespace-selector-${namespace}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({}, isSelectedProps(namespace), {
      key: namespace,
      "data-test-subj": `namespace-selector-menu-item-${namespace}`,
      onClick: () => {
        onSelectedNamespaceChange(namespace);
      }
    }), namespace), index < namespaces.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none",
      key: `rule-${namespace}`
    })));
  }, [namespaces, isSelectedProps, onSelectedNamespaceChange]);
  const button = (0, _react.useMemo)(() => {
    const title = _i18n.i18n.translate('xpack.csp.namespaceSelector.title', {
      defaultMessage: 'Namespace'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "namespace-selector-dropdown-button",
      flush: "both",
      iconSide: "right",
      iconSize: "s",
      iconType: "arrowDown",
      onClick: onButtonClick,
      title: activeNamespace,
      size: "xs",
      disabled: namespaces.length < 2
    }, `${title}: ${activeNamespace}`);
  }, [onButtonClick, activeNamespace, namespaces.length]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "namespace-selector",
    button: button,
    closePopover: closePopover,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "namespace-selector-menu",
    size: "s",
    items: menuItems
  }));
};
exports.NamespaceSelector = NamespaceSelector;