"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPostureInput = exports.isCloudProviderInput = exports.isCloudConnectorsEnabled = exports.isBelowMinVersion = exports.hasPolicyTemplateInputs = exports.hasErrors = exports.getVulnMgmtCloudFormationDefaultValue = exports.getPosturePolicy = exports.getPostureInputHiddenVars = exports.getPolicyTemplateInputOptions = exports.getMaxPackageName = exports.getKibanaComponentId = exports.getDeploymentIdFromUrl = exports.getDefaultGcpHiddenVars = exports.getDefaultAzureCredentialsType = exports.getDefaultAwsCredentialsType = exports.getCspmCloudShellDefaultValue = exports.getCspmCloudFormationDefaultValue = exports.getCloudProviderFromCloudHost = exports.getCloudProvider = exports.getCloudDefaultAwsCredentialConfig = exports.getCloudCredentialVarsConfig = exports.getCloudConnectorRemoteRoleTemplate = exports.getAwsCredentialsType = exports.getArmTemplateUrlFromCspmPackage = exports.findVariableDef = exports.fieldIsInvalid = exports.POSTURE_NAMESPACE = exports.POLICY_TEMPLATE_FORM_DTS = void 0;
var _public = require("@kbn/fleet-plugin/public");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _lodash = require("lodash");
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _coerce = _interopRequireDefault(require("semver/functions/coerce"));
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _std = require("@kbn/std");
var _constants = require("../../../common/constants");
var _constants2 = require("../../common/constants");
var _eks_credentials_form = require("./eks_credentials_form");
var _get_aws_credentials_form_options = require("./aws_credentials_form/get_aws_credentials_form_options");
var _gcp_credential_form = require("./gcp_credentials_form/gcp_credential_form");
var _azure_credentials_form = require("./azure_credentials_form/azure_credentials_form");
var _aws_credentials_form = require("./aws_credentials_form/aws_credentials_form");
var _get_template_url_package_info = require("../../common/utils/get_template_url_package_info");
var _policy_template_form = require("./policy_template_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Posture policies only support the default namespace
const POSTURE_NAMESPACE = exports.POSTURE_NAMESPACE = 'default';

// we need to add more types depending integrations such Asset Inventory

// Extend NewPackagePolicyInput with known string literals for input type and policy template

const isPostureInput = input => _constants.SUPPORTED_POLICY_TEMPLATES.includes(input.policy_template) && _constants.SUPPORTED_CLOUDBEAT_INPUTS.includes(input.type);
exports.isPostureInput = isPostureInput;
const getPostureType = policyTemplateInput => {
  switch (policyTemplateInput) {
    case _constants.CLOUDBEAT_AWS:
    case _constants.CLOUDBEAT_AZURE:
    case _constants.CLOUDBEAT_GCP:
      return 'cspm';
    case _constants.CLOUDBEAT_VANILLA:
    case _constants.CLOUDBEAT_EKS:
      return 'kspm';
    case _constants.CLOUDBEAT_VULN_MGMT_AWS:
      return 'vuln_mgmt';
    default:
      return 'n/a';
  }
};
const getDeploymentType = policyTemplateInput => {
  switch (policyTemplateInput) {
    case _constants.CLOUDBEAT_AWS:
    case _constants.CLOUDBEAT_VULN_MGMT_AWS:
      return 'aws';
    case _constants.CLOUDBEAT_AZURE:
      return 'azure';
    case _constants.CLOUDBEAT_GCP:
      return 'gcp';
    case _constants.CLOUDBEAT_VANILLA:
      return 'self_managed';
    case _constants.CLOUDBEAT_EKS:
      return 'eks';
    default:
      return 'n/a';
  }
};
const getPostureInput = (input, inputType, inputVars) => {
  const isInputEnabled = input.type === inputType;
  return {
    ...input,
    enabled: isInputEnabled,
    streams: input.streams.map(stream => ({
      ...stream,
      enabled: isInputEnabled,
      // Merge new vars with existing vars
      ...(isInputEnabled && inputVars && {
        vars: {
          ...stream.vars,
          ...inputVars
        }
      })
    }))
  };
};

/**
 * Get a new object with the updated policy input and vars
 */
const getPosturePolicy = (newPolicy, inputType, inputVars) => ({
  ...newPolicy,
  namespace: newPolicy.namespace,
  // Enable new policy input and disable all others
  inputs: newPolicy.inputs.map(item => getPostureInput(item, inputType, inputVars)),
  // Set hidden policy vars
  vars: (0, _lodash.merge)({}, newPolicy.vars, {
    deployment: {
      value: getDeploymentType(inputType)
    },
    posture: {
      value: getPostureType(inputType)
    }
  })
});
exports.getPosturePolicy = getPosturePolicy;
// type guard for checking inputs
const hasPolicyTemplateInputs = policyTemplate => {
  return Object.hasOwn(policyTemplate, 'inputs');
};
exports.hasPolicyTemplateInputs = hasPolicyTemplateInputs;
const getVulnMgmtCloudFormationDefaultValue = packageInfo => {
  if (!packageInfo.policy_templates) return '';
  const vulnMgmtPolicyTemplate = packageInfo.policy_templates.find(p => p.name === _constants.VULN_MGMT_POLICY_TEMPLATE);
  if (!vulnMgmtPolicyTemplate) return '';
  const vulnMgmtInputs = hasPolicyTemplateInputs(vulnMgmtPolicyTemplate) && vulnMgmtPolicyTemplate.inputs;
  if (!vulnMgmtInputs) return '';
  const cloudFormationTemplate = vulnMgmtInputs.reduce((acc, input) => {
    var _input$vars$find;
    if (!input.vars) return acc;
    const template = (_input$vars$find = input.vars.find(v => v.name === 'cloud_formation_template')) === null || _input$vars$find === void 0 ? void 0 : _input$vars$find.default;
    return template ? String(template) : acc;
  }, '');
  return cloudFormationTemplate;
};
exports.getVulnMgmtCloudFormationDefaultValue = getVulnMgmtCloudFormationDefaultValue;
const getCspmCloudFormationDefaultValue = packageInfo => {
  if (!packageInfo.policy_templates) return '';
  const policyTemplate = packageInfo.policy_templates.find(p => p.name === _cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE);
  if (!policyTemplate) return '';
  const policyTemplateInputs = hasPolicyTemplateInputs(policyTemplate) && policyTemplate.inputs;
  if (!policyTemplateInputs) return '';
  const cloudFormationTemplate = policyTemplateInputs.reduce((acc, input) => {
    var _input$vars$find2;
    if (!input.vars) return acc;
    const template = (_input$vars$find2 = input.vars.find(v => v.name === 'cloud_formation_template')) === null || _input$vars$find2 === void 0 ? void 0 : _input$vars$find2.default;
    return template ? String(template) : acc;
  }, '');
  return cloudFormationTemplate;
};
exports.getCspmCloudFormationDefaultValue = getCspmCloudFormationDefaultValue;
const getArmTemplateUrlFromCspmPackage = packageInfo => {
  if (!packageInfo.policy_templates) return '';
  const policyTemplate = packageInfo.policy_templates.find(p => p.name === _cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE);
  if (!policyTemplate) return '';
  const policyTemplateInputs = hasPolicyTemplateInputs(policyTemplate) && policyTemplate.inputs;
  if (!policyTemplateInputs) return '';
  const armTemplateUrl = policyTemplateInputs.reduce((acc, input) => {
    var _input$vars$find3;
    if (!input.vars) return acc;
    const template = (_input$vars$find3 = input.vars.find(v => v.name === 'arm_template_url')) === null || _input$vars$find3 === void 0 ? void 0 : _input$vars$find3.default;
    return template ? String(template) : acc;
  }, '');
  return armTemplateUrl;
};
exports.getArmTemplateUrlFromCspmPackage = getArmTemplateUrlFromCspmPackage;
const getDefaultAwsCredentialsType = (packageInfo, showCloudConnectors, setupTechnology) => {
  if (setupTechnology && setupTechnology === _public.SetupTechnology.AGENTLESS) {
    return showCloudConnectors ? _aws_credentials_form.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS : _aws_credentials_form.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS;
  }
  const hasCloudFormationTemplate = !!getCspmCloudFormationDefaultValue(packageInfo);
  if (hasCloudFormationTemplate) {
    return _aws_credentials_form.AWS_CREDENTIALS_TYPE.CLOUD_FORMATION;
  }
  return _get_aws_credentials_form_options.DEFAULT_MANUAL_AWS_CREDENTIALS_TYPE;
};
exports.getDefaultAwsCredentialsType = getDefaultAwsCredentialsType;
const getCloudDefaultAwsCredentialConfig = ({
  isAgentless,
  showCloudConnectors,
  packageInfo
}) => {
  let credentialsType;
  const hasCloudFormationTemplate = !!getCspmCloudFormationDefaultValue(packageInfo);
  if (!showCloudConnectors && isAgentless) {
    credentialsType = _get_aws_credentials_form_options.DEFAULT_AGENTLESS_AWS_CREDENTIALS_TYPE;
  } else if (showCloudConnectors && isAgentless) {
    credentialsType = _get_aws_credentials_form_options.DEFAULT_AGENTLESS_CLOUD_CONNECTORS_AWS_CREDENTIALS_TYPE;
  } else if (hasCloudFormationTemplate && !isAgentless) {
    credentialsType = _get_aws_credentials_form_options.DEFAULT_AWS_CREDENTIALS_TYPE;
  } else {
    credentialsType = _get_aws_credentials_form_options.DEFAULT_MANUAL_AWS_CREDENTIALS_TYPE;
  }
  const config = {
    'aws.credentials.type': {
      value: credentialsType,
      type: 'text'
    },
    ...(showCloudConnectors && {
      'aws.supports_cloud_connectors': {
        value: showCloudConnectors,
        type: 'bool'
      }
    })
  };
  return config;
};
exports.getCloudDefaultAwsCredentialConfig = getCloudDefaultAwsCredentialConfig;
const getDefaultAzureCredentialsType = (packageInfo, setupTechnology) => {
  if (setupTechnology && setupTechnology === _public.SetupTechnology.AGENTLESS) {
    return _azure_credentials_form.AZURE_CREDENTIALS_TYPE.SERVICE_PRINCIPAL_WITH_CLIENT_SECRET;
  }
  const hasArmTemplateUrl = !!getArmTemplateUrlFromCspmPackage(packageInfo);
  if (hasArmTemplateUrl) {
    return _azure_credentials_form.AZURE_CREDENTIALS_TYPE.ARM_TEMPLATE;
  }
  return _azure_credentials_form.AZURE_CREDENTIALS_TYPE.MANAGED_IDENTITY;
};
exports.getDefaultAzureCredentialsType = getDefaultAzureCredentialsType;
const getDefaultGcpHiddenVars = (packageInfo, setupTechnology) => {
  if (setupTechnology && setupTechnology === _public.SetupTechnology.AGENTLESS) {
    return {
      'gcp.credentials.type': {
        value: _gcp_credential_form.GCP_CREDENTIALS_TYPE.CREDENTIALS_JSON,
        type: 'text'
      }
    };
  }
  const hasCloudShellUrl = !!getCspmCloudShellDefaultValue(packageInfo);
  if (hasCloudShellUrl) {
    return {
      'gcp.credentials.type': {
        value: _gcp_credential_form.GCP_CREDENTIALS_TYPE.CREDENTIALS_NONE,
        type: 'text'
      }
    };
  }
  return {
    'gcp.credentials.type': {
      value: _gcp_credential_form.GCP_CREDENTIALS_TYPE.CREDENTIALS_FILE,
      type: 'text'
    }
  };
};

/**
 * Input vars that are hidden from the user
 */
exports.getDefaultGcpHiddenVars = getDefaultGcpHiddenVars;
const getPostureInputHiddenVars = (inputType, packageInfo, setupTechnology, showCloudConnectors) => {
  switch (inputType) {
    case 'cloudbeat/cis_aws':
      return getCloudDefaultAwsCredentialConfig({
        isAgentless: setupTechnology === _public.SetupTechnology.AGENTLESS,
        packageInfo,
        showCloudConnectors
      });
    case 'cloudbeat/cis_azure':
      return {
        'azure.credentials.type': {
          value: getDefaultAzureCredentialsType(packageInfo, setupTechnology),
          type: 'text'
        }
      };
    case 'cloudbeat/cis_gcp':
      return getDefaultGcpHiddenVars(packageInfo, setupTechnology);
    case 'cloudbeat/cis_eks':
      return {
        'aws.credentials.type': {
          value: _eks_credentials_form.DEFAULT_EKS_VARS_GROUP,
          type: 'text'
        }
      };
    default:
      return undefined;
  }
};
exports.getPostureInputHiddenVars = getPostureInputHiddenVars;
const getPolicyTemplateInputOptions = policyTemplate => _constants2.cloudPostureIntegrations[policyTemplate].options.map(o => ({
  tooltip: o.tooltip,
  value: o.type,
  id: o.type,
  label: o.name,
  icon: o.icon,
  disabled: o.disabled,
  isBeta: o.isBeta,
  testId: o.testId
}));
exports.getPolicyTemplateInputOptions = getPolicyTemplateInputOptions;
const getMaxPackageName = (packageName, packagePolicies) => {
  // Retrieve the highest number appended to package policy name and increment it by one
  const pkgPoliciesNamePattern = new RegExp(`${packageName}-(\\d+)`);
  const maxPkgPolicyName = Math.max(...(packagePolicies !== null && packagePolicies !== void 0 ? packagePolicies : []).filter(ds => Boolean(ds.name.match(pkgPoliciesNamePattern))).map(ds => parseInt(ds.name.match(pkgPoliciesNamePattern)[1], 10)), 0);
  return `${packageName}-${maxPkgPolicyName + 1}`;
};
exports.getMaxPackageName = getMaxPackageName;
const getCspmCloudShellDefaultValue = packageInfo => {
  if (!packageInfo.policy_templates) return '';
  const policyTemplate = packageInfo.policy_templates.find(p => p.name === _cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE);
  if (!policyTemplate) return '';
  const policyTemplateInputs = hasPolicyTemplateInputs(policyTemplate) && policyTemplate.inputs;
  if (!policyTemplateInputs) return '';
  const cloudShellUrl = policyTemplateInputs.reduce((acc, input) => {
    var _input$vars$find4;
    if (!input.vars) return acc;
    const template = (_input$vars$find4 = input.vars.find(v => v.name === 'cloud_shell_url')) === null || _input$vars$find4 === void 0 ? void 0 : _input$vars$find4.default;
    return template ? String(template) : acc;
  }, '');
  return cloudShellUrl;
};
exports.getCspmCloudShellDefaultValue = getCspmCloudShellDefaultValue;
const getAwsCredentialsType = input => {
  var _input$streams$0$vars;
  return (_input$streams$0$vars = input.streams[0].vars) === null || _input$streams$0$vars === void 0 ? void 0 : _input$streams$0$vars['aws.credentials.type'].value;
};
exports.getAwsCredentialsType = getAwsCredentialsType;
const isBelowMinVersion = (version, minVersion) => {
  const semanticVersion = (0, _valid.default)(version);
  const versionNumberOnly = (0, _coerce.default)(semanticVersion) || '';
  return (0, _lt.default)(versionNumberOnly, minVersion);
};

/**
 * Searches for a variable definition in a given packageInfo object based on a specified key.
 * It navigates through nested arrays within the packageInfo object to locate the variable definition associated with the provided key.
 * If found, it returns the variable definition object; otherwise, it returns undefined.
 */
exports.isBelowMinVersion = isBelowMinVersion;
const findVariableDef = (packageInfo, key) => {
  var _packageInfo$data_str;
  return packageInfo === null || packageInfo === void 0 ? void 0 : (_packageInfo$data_str = packageInfo.data_streams) === null || _packageInfo$data_str === void 0 ? void 0 : _packageInfo$data_str.filter(datastreams => datastreams !== undefined).map(ds => ds.streams).filter(streams => streams !== undefined).flat().filter(streams => (streams === null || streams === void 0 ? void 0 : streams.vars) !== undefined).map(cis => cis === null || cis === void 0 ? void 0 : cis.vars).flat().find(vars => (vars === null || vars === void 0 ? void 0 : vars.name) === key);
};
exports.findVariableDef = findVariableDef;
const fieldIsInvalid = (value, hasInvalidRequiredVars) => hasInvalidRequiredVars && !value;
exports.fieldIsInvalid = fieldIsInvalid;
const POLICY_TEMPLATE_FORM_DTS = exports.POLICY_TEMPLATE_FORM_DTS = {
  LOADER: 'policy-template-form-loader'
};
const hasErrors = validationResults => {
  if (!validationResults) return 0;
  const flattenedValidation = (0, _std.getFlattenedObject)(validationResults);
  const errors = Object.values(flattenedValidation).filter(value => Boolean(value)) || [];
  return errors.length;
};
exports.hasErrors = hasErrors;
const isCloudProviderInput = type => {
  // TODO: ADD azure, gcp when cloud connector is  available on providers
  const providers = ['aws'];
  return providers.some(provider => type.includes(provider));
};
exports.isCloudProviderInput = isCloudProviderInput;
const isCloudConnectorsEnabled = (credentialsType, isAgentless) => {
  if (!credentialsType || !isAgentless) {
    return false;
  }
  return isAgentless && credentialsType === _aws_credentials_form.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS;
};
exports.isCloudConnectorsEnabled = isCloudConnectorsEnabled;
const getCloudProviderFromCloudHost = cloudHost => {
  var _cloudHost$match;
  if (!cloudHost) return undefined;
  const match = (_cloudHost$match = cloudHost.match(/\b(aws|gcp|azure)\b/)) === null || _cloudHost$match === void 0 ? void 0 : _cloudHost$match[1];
  return match;
};
exports.getCloudProviderFromCloudHost = getCloudProviderFromCloudHost;
const getDeploymentIdFromUrl = url => {
  if (!url) return undefined;
  const match = url.match(/\/deployments\/([^/?#]+)/);
  return match === null || match === void 0 ? void 0 : match[1];
};
exports.getDeploymentIdFromUrl = getDeploymentIdFromUrl;
const getKibanaComponentId = cloudId => {
  if (!cloudId) return undefined;
  const base64Part = cloudId.split(':')[1];
  const decoded = atob(base64Part);
  const [,, kibanaComponentId] = decoded.split('$');
  return kibanaComponentId || undefined;
};
exports.getKibanaComponentId = getKibanaComponentId;
const getCloudConnectorRemoteRoleTemplate = ({
  input,
  cloud,
  packageInfo
}) => {
  var _input$streams$0$vars2, _input$streams, _input$streams$, _input$streams$$vars, _input$streams$$vars$, _cloud$serverless, _getTemplateUrlFromPa, _getTemplateUrlFromPa2;
  let elasticResourceId;
  const accountType = (_input$streams$0$vars2 = input === null || input === void 0 ? void 0 : (_input$streams = input.streams) === null || _input$streams === void 0 ? void 0 : (_input$streams$ = _input$streams[0]) === null || _input$streams$ === void 0 ? void 0 : (_input$streams$$vars = _input$streams$.vars) === null || _input$streams$$vars === void 0 ? void 0 : (_input$streams$$vars$ = _input$streams$$vars['aws.account_type']) === null || _input$streams$$vars$ === void 0 ? void 0 : _input$streams$$vars$.value) !== null && _input$streams$0$vars2 !== void 0 ? _input$streams$0$vars2 : _policy_template_form.AWS_SINGLE_ACCOUNT;
  const provider = getCloudProviderFromCloudHost(cloud === null || cloud === void 0 ? void 0 : cloud.cloudHost);
  if (!provider || provider !== 'aws') return undefined;
  const deploymentId = getDeploymentIdFromUrl(cloud === null || cloud === void 0 ? void 0 : cloud.deploymentUrl);
  const kibanaComponentId = getKibanaComponentId(cloud === null || cloud === void 0 ? void 0 : cloud.cloudId);
  if (cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled && cloud !== null && cloud !== void 0 && (_cloud$serverless = cloud.serverless) !== null && _cloud$serverless !== void 0 && _cloud$serverless.projectId) {
    elasticResourceId = cloud.serverless.projectId;
  }
  if (cloud !== null && cloud !== void 0 && cloud.isCloudEnabled && deploymentId && kibanaComponentId) {
    elasticResourceId = kibanaComponentId;
  }
  if (!elasticResourceId) return undefined;
  return (_getTemplateUrlFromPa = (0, _get_template_url_package_info.getTemplateUrlFromPackageInfo)(packageInfo, input.policy_template, _get_template_url_package_info.SUPPORTED_TEMPLATES_URL_FROM_PACKAGE_INFO_INPUT_VARS.CLOUD_FORMATION_CLOUD_CONNECTORS)) === null || _getTemplateUrlFromPa === void 0 ? void 0 : (_getTemplateUrlFromPa2 = _getTemplateUrlFromPa.replace(_constants.TEMPLATE_URL_ACCOUNT_TYPE_ENV_VAR, accountType)) === null || _getTemplateUrlFromPa2 === void 0 ? void 0 : _getTemplateUrlFromPa2.replace(_constants.TEMPLATE_URL_ELASTIC_RESOURCE_ID_ENV_VAR, elasticResourceId);
};
exports.getCloudConnectorRemoteRoleTemplate = getCloudConnectorRemoteRoleTemplate;
const getCloudProvider = type => {
  if (type.includes('aws')) return 'aws';
  if (type.includes('azure')) return 'azure';
  if (type.includes('gcp')) return 'gcp';
  return undefined;
};
exports.getCloudProvider = getCloudProvider;
const getCloudCredentialVarsConfig = ({
  setupTechnology,
  optionId,
  showCloudConnectors,
  inputType
}) => {
  const supportsCloudConnector = setupTechnology === _public.SetupTechnology.AGENTLESS && optionId === _aws_credentials_form.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS && showCloudConnectors;
  const credentialType = `${getCloudProvider(inputType)}.credentials.type`;
  const supportCloudConnectors = `${getCloudProvider(inputType)}.supports_cloud_connectors`;
  if (showCloudConnectors) {
    return {
      [credentialType]: {
        value: optionId
      },
      [supportCloudConnectors]: {
        value: supportsCloudConnector
      }
    };
  }
  return {
    [credentialType]: {
      value: optionId
    }
  };
};
exports.getCloudCredentialVarsConfig = getCloudCredentialVarsConfig;