"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  DELETE_TITLE: true,
  CONFIRM_QUESTION: true
};
exports.DELETE_TITLE = exports.CONFIRM_QUESTION = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DELETE_TITLE = caseTitle => _i18n.i18n.translate('xpack.cases.confirmDeleteCase.deleteTitle', {
  values: {
    caseTitle
  },
  defaultMessage: 'Delete "{caseTitle}"'
});
exports.DELETE_TITLE = DELETE_TITLE;
const CONFIRM_QUESTION = quantity => _i18n.i18n.translate('xpack.cases.confirmDeleteCase.confirmQuestion', {
  values: {
    quantity
  },
  defaultMessage: 'By deleting {quantity, plural, =1 {this case} other {these cases}}, all related case data will be permanently removed and you will no longer be able to push data to an external incident management system. Are you sure you wish to proceed?'
});
exports.CONFIRM_QUESTION = CONFIRM_QUESTION;