"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidTimeInterval = exports.getTimeInterval = exports.createTimeInterval = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var TIME_UNIT = /*#__PURE__*/function (TIME_UNIT) {
  TIME_UNIT["SECONDS"] = "s";
  TIME_UNIT["MINUTES"] = "m";
  TIME_UNIT["HOURS"] = "h";
  TIME_UNIT["DAYS"] = "d";
  return TIME_UNIT;
}(TIME_UNIT || {});
const multipliers = {
  [TIME_UNIT.SECONDS]: 1000,
  [TIME_UNIT.MINUTES]: 1000 * 60,
  [TIME_UNIT.HOURS]: 1000 * 60 * 60,
  [TIME_UNIT.DAYS]: 1000 * 60 * 60 * 24
};
function isTimeUnit(unit) {
  return unit !== undefined;
}
const isValidTimeInterval = (val = '') => {
  return !!String(val).match(/^([0-9]{1,})([hmsd])$/);
};
exports.isValidTimeInterval = isValidTimeInterval;
const getTimeInterval = (val = '') => {
  // if it's a number, there is no interval, return undefined
  if (!isNaN(Number(val))) {
    return;
  }

  // if it's a string, try to parse out the shorthand duration value
  const match = String(val).match(/^([0-9]{1,})([hmsd])$/);

  // if it's invalid, there is no interval, return undefined
  if (!match) {
    return;
  }
  const interval = parseInt(match[1], 10);
  const unit = match[2];
  const multiplier = isTimeUnit(unit) ? multipliers[unit] : null;
  if (interval && multiplier) {
    return interval * multiplier;
  }
};
exports.getTimeInterval = getTimeInterval;
const createTimeInterval = seconds => {
  if (seconds < multipliers[TIME_UNIT.MINUTES]) {
    return seconds / multipliers[TIME_UNIT.SECONDS] + TIME_UNIT.SECONDS;
  }
  if (seconds < multipliers[TIME_UNIT.HOURS]) {
    return seconds / multipliers[TIME_UNIT.MINUTES] + TIME_UNIT.MINUTES;
  }
  if (seconds < multipliers[TIME_UNIT.DAYS]) {
    return seconds / multipliers[TIME_UNIT.HOURS] + TIME_UNIT.HOURS;
  }
  return seconds / multipliers[TIME_UNIT.DAYS] + TIME_UNIT.DAYS;
};
exports.createTimeInterval = createTimeInterval;