"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDefaultTimeRange = useDefaultTimeRange;
var _public = require("@kbn/data-plugin/public");
var _use_apm_plugin_context = require("../context/apm_plugin/use_apm_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDefaultTimeRange() {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    from: rangeFrom,
    to: rangeTo
  } = core.uiSettings.get(_public.UI_SETTINGS.TIMEPICKER_TIME_DEFAULTS);
  return {
    rangeFrom,
    rangeTo
  };
}