"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legacyBackends = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _queryString = _interopRequireDefault(require("query-string"));
var _comparison_rt = require("../../../../common/comparison_rt");
var _use_apm_params = require("../../../hooks/use_apm_params");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RedirectBackends({
  to
}) {
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/backends/*');
  const search = _queryString.default.stringify(query);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: to,
      search
    }
  });
}
function RedirectBackendsOverviewToDependenciesOverview() {
  const {
    path: {
      dependencyName
    },
    query
  } = (0, _use_apm_params.useApmParams)('/backends/{dependencyName}/overview');
  const search = _queryString.default.stringify({
    ...query,
    dependencyName
  });
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `/dependencies/overview`,
      search
    }
  });
}
const legacyBackends = exports.legacyBackends = {
  '/backends/inventory': {
    element: /*#__PURE__*/_react.default.createElement(RedirectBackends, {
      to: "/dependencies/inventory"
    }),
    params: t.partial({
      query: t.intersection([t.type({
        comparisonEnabled: _ioTsUtils.toBooleanRt
      }), _comparison_rt.offsetRt])
    })
  },
  '/backends/{dependencyName}/overview': {
    element: /*#__PURE__*/_react.default.createElement(RedirectBackendsOverviewToDependenciesOverview, null),
    params: t.type({
      path: t.type({
        dependencyName: t.string
      })
    })
  },
  '/backends': {
    element: /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null),
    params: t.partial({
      query: t.intersection([t.type({
        comparisonEnabled: _ioTsUtils.toBooleanRt,
        dependencyName: t.string
      }), _comparison_rt.offsetRt])
    }),
    children: {
      '/backends': {
        element: /*#__PURE__*/_react.default.createElement(RedirectBackends, {
          to: "/dependencies"
        })
      },
      '/backends/operations': {
        element: /*#__PURE__*/_react.default.createElement(RedirectBackends, {
          to: "/dependencies/operations"
        })
      },
      '/backends/operation': {
        params: t.type({
          query: t.intersection([t.type({
            spanName: t.string
          }), t.partial({
            sampleRangeFrom: _ioTsUtils.toNumberRt,
            sampleRangeTo: _ioTsUtils.toNumberRt
          })])
        }),
        element: /*#__PURE__*/_react.default.createElement(RedirectBackends, {
          to: "/dependencies/operation"
        })
      },
      '/backends/overview': {
        element: /*#__PURE__*/_react.default.createElement(RedirectBackends, {
          to: "/dependencies/overview"
        })
      }
    }
  }
};