"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiTextDiff = void 0;
var _react = _interopRequireWildcard(require("react"));
var _textDiff = _interopRequireDefault(require("text-diff"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _text_diff = require("./text_diff.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "insertComponent", "deleteComponent", "sameComponent", "beforeText", "afterText", "timeout"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var useEuiTextDiff = exports.useEuiTextDiff = function useEuiTextDiff(_ref) {
  var className = _ref.className,
    _ref$insertComponent = _ref.insertComponent,
    insertComponent = _ref$insertComponent === void 0 ? 'ins' : _ref$insertComponent,
    _ref$deleteComponent = _ref.deleteComponent,
    deleteComponent = _ref$deleteComponent === void 0 ? 'del' : _ref$deleteComponent,
    sameComponent = _ref.sameComponent,
    _ref$beforeText = _ref.beforeText,
    beforeText = _ref$beforeText === void 0 ? '' : _ref$beforeText,
    _ref$afterText = _ref.afterText,
    afterText = _ref$afterText === void 0 ? '' : _ref$afterText,
    _ref$timeout = _ref.timeout,
    timeout = _ref$timeout === void 0 ? 0.1 : _ref$timeout,
    rest = _objectWithoutProperties(_ref, _excluded);
  var textDiff = (0, _react.useMemo)(function () {
    var diff = new _textDiff.default({
      timeout: timeout
    }); // options may be passed to constructor

    return diff.main(beforeText, afterText);
  }, [beforeText, afterText, timeout]); // produces diff array

  var styles = (0, _services.useEuiMemoizedStyles)(_text_diff.euiTextDiffStyles);
  var classes = (0, _classnames.default)('euiTextDiff', className);
  var rendereredHtml = (0, _react.useMemo)(function () {
    var html = [];
    if (textDiff) for (var i = 0; i < textDiff.length; i++) {
      var Element = void 0;
      var el = textDiff[i];
      if (el[0] === 1) Element = insertComponent;else if (el[0] === -1) Element = deleteComponent;else if (sameComponent) Element = sameComponent;
      if (Element) html.push((0, _react2.jsx)(Element, {
        key: i
      }, el[1]));else html.push(el[1]);
    }
    return html;
  }, [textDiff, deleteComponent, insertComponent, sameComponent]); // produces diff array

  // specifically defining the return type here as the
  // inferred type is not correct: array vs tuple
  var textDiffResult = [(0, _react2.jsx)("span", _extends({
    css: styles.euiTextDiff,
    className: classes
  }, rest), rendereredHtml), textDiff];
  return textDiffResult;
};