"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.OptInConfigService = void 0;
var OptInConfigService = /** @class */ (function () {
    function OptInConfigService(optInConfig) {
        this.optInConfig = optInConfig;
    }
    /**
     * Is globally opted in?
     */
    OptInConfigService.prototype.isOptedIn = function () {
        return this.optInConfig.global.enabled;
    };
    /**
     * Is the given event type opted in?
     * @param eventType the event type to check
     */
    OptInConfigService.prototype.isEventTypeOptedIn = function (eventType) {
        var _a, _b;
        if (!this.isOptedIn()) {
            return false;
        }
        // In case of not provided a specific eventType consent, we assume opted-in
        var isEventTypeOptedIn = (_b = (this.optInConfig.event_types && ((_a = this.optInConfig.event_types[eventType]) === null || _a === void 0 ? void 0 : _a.enabled))) !== null && _b !== void 0 ? _b : true;
        return isEventTypeOptedIn;
    };
    /**
     * Is the given shipper opted in?
     * @param shipperName the shipper to check
     * @param eventType the event type to check for the shipper
     */
    OptInConfigService.prototype.isShipperOptedIn = function (shipperName, eventType) {
        var _a, _b;
        if (!this.isOptedIn()) {
            return false;
        }
        // In case of not provided a specific shipper consent, we assume opted-in
        var isShipperGloballyOptedIn = (_a = (this.optInConfig.global.shippers && this.optInConfig.global.shippers[shipperName])) !== null && _a !== void 0 ? _a : true;
        if (!isShipperGloballyOptedIn) {
            return false;
        }
        if (eventType) {
            if (!this.isEventTypeOptedIn(eventType)) {
                return false;
            }
            var eventTypeOptInConfig = this.optInConfig.event_types && this.optInConfig.event_types[eventType];
            // In case of not provided a specific eventType-level shipper consent, we assume opted-in
            var isEventTypeShipperOptedIn = (_b = ((eventTypeOptInConfig === null || eventTypeOptInConfig === void 0 ? void 0 : eventTypeOptInConfig.shippers) && eventTypeOptInConfig.shippers[shipperName])) !== null && _b !== void 0 ? _b : true;
            return isEventTypeShipperOptedIn;
        }
        else {
            return isShipperGloballyOptedIn;
        }
    };
    return OptInConfigService;
}());
exports.OptInConfigService = OptInConfigService;
