"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUseUnrefinedResults = void 0;
var _get_max_retries_reached = require("../../../../helpers/get_max_retries_reached");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUseUnrefinedResults = ({
  generationAttempts,
  maxGenerationAttempts,
  unrefinedResults
}) => {
  const nextAttemptWouldExcedLimit = (0, _get_max_retries_reached.getMaxRetriesReached)({
    generationAttempts: generationAttempts + 1,
    // + 1, because we just used an attempt
    maxGenerationAttempts
  });
  return nextAttemptWouldExcedLimit && unrefinedResults != null && unrefinedResults.length > 0;
};
exports.getUseUnrefinedResults = getUseUnrefinedResults;