"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAvailableAiConnectors = void 0;
var _managementSettingsIds = require("@kbn/management-settings-ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get the available AI connectors based on the default AI connector settings. This is only a
 * client side filter and does not make any API calls.
 *
 * @param allAiConnectors - The list of all AI connectors.
 * @param settings - Kibana SettingsStart.
 * @returns The available AI connectors.
 */
const getAvailableAiConnectors = ({
  allAiConnectors,
  settings
}) => {
  const defaultAiConnectorId = settings.client.get(_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR);
  const defaultAiConnectorOnly = settings.client.get(_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY, false);
  const availableConnectors = allAiConnectors.filter(connector => {
    if (defaultAiConnectorOnly) {
      return connector.id === defaultAiConnectorId;
    }
    return true;
  });
  const aiConnectors = availableConnectors.length > 0 ? availableConnectors : allAiConnectors;
  return aiConnectors;
};
exports.getAvailableAiConnectors = getAvailableAiConnectors;