"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createExampleSolutionViewRootProfileProvider = exports.createExampleRootProfileProvider = void 0;
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _react = _interopRequireWildcard(require("react"));
var _profiles = require("../../../profiles");
var _example_context = require("../example_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createExampleRootProfileProvider = () => ({
  profileId: 'example-root-profile',
  isExperimental: true,
  profile: {
    getRenderAppWrapper,
    getDefaultAdHocDataViews,
    getCellRenderers: prev => params => ({
      ...prev(params),
      '@timestamp': props => {
        const timestamp = (0, _discoverUtils.getFieldValue)(props.row, '@timestamp');
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          title: timestamp,
          "data-test-subj": "exampleRootProfileTimestamp"
        }, timestamp);
      }
    }),
    /**
     * The `getAppMenu` extension point gives access to AppMenuRegistry with methods registerCustomAction and registerCustomActionUnderSubmenu.
     * The extension also provides the essential params like current dataView, adHocDataViews etc when defining a custom action implementation.
     * And it supports opening custom flyouts and any other modals on the click.
     * `getAppMenu` can be configured in both root and data source profiles.
     * @param prev
     */
    getAppMenu: prev => params => {
      const prevValue = prev(params);

      // Check `params` for the available deps

      return {
        appMenuRegistry: registry => {
          // Note: Only 2 custom actions are allowed to be rendered in the app menu. The rest will be ignored.

          // Register a custom submenu action
          registry.registerCustomAction({
            id: 'example-custom-root-submenu',
            type: _discoverUtils.AppMenuActionType.custom,
            label: 'Custom Submenu',
            testId: 'example-custom-root-submenu',
            actions: [{
              id: 'example-custom-root-action11',
              type: _discoverUtils.AppMenuActionType.custom,
              controlProps: {
                label: 'Custom action 11 (from Root profile)',
                testId: 'example-custom-root-action11',
                onClick: ({
                  onFinishAction
                }) => {
                  alert('Example Root Custom action 11 clicked');
                  onFinishAction(); // This allows to close the popover and return focus back to the app menu DOM node
                }
              }
            }, {
              id: 'example-custom-root-action12',
              type: _discoverUtils.AppMenuActionType.custom,
              controlProps: {
                label: 'Custom action 12 (from Root profile)',
                testId: 'example-custom-root-action12',
                onClick: ({
                  onFinishAction
                }) => {
                  // This is an example of a custom action that opens a flyout or any other custom modal.
                  // To do so, simply return a React element and call onFinishAction when you're done.
                  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
                    onClose: onFinishAction,
                    "data-test-subj": "example-custom-root-action12-flyout"
                  }, /*#__PURE__*/_react.default.createElement("div", null, "Example custom action clicked"));
                }
              }
            }]
          });
          return prevValue.appMenuRegistry(registry);
        }
      };
    }
  },
  resolve: params => {
    if (params.solutionNavId != null) {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        solutionType: _profiles.SolutionType.Default
      }
    };
  }
});
exports.createExampleRootProfileProvider = createExampleRootProfileProvider;
const createExampleSolutionViewRootProfileProvider = () => ({
  profileId: 'example-solution-view-root-profile',
  isExperimental: true,
  profile: {
    getRenderAppWrapper,
    getDefaultAdHocDataViews
  },
  resolve: params => ({
    isMatch: true,
    context: {
      solutionType: params.solutionNavId
    }
  })
});
exports.createExampleSolutionViewRootProfileProvider = createExampleSolutionViewRootProfileProvider;
const getRenderAppWrapper = PrevWrapper => ({
  children
}) => {
  const [currentMessage, setCurrentMessage] = (0, _react.useState)(undefined);
  return /*#__PURE__*/_react.default.createElement(PrevWrapper, null, /*#__PURE__*/_react.default.createElement(_example_context.ExampleContextProvider, {
    value: {
      currentMessage,
      setCurrentMessage
    }
  }, children, currentMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    type: "push",
    maxWidth: 500,
    onClose: () => setCurrentMessage(undefined),
    "data-test-subj": "exampleRootProfileFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, "Inspect message"))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    "data-test-subj": "exampleRootProfileCurrentMessage"
  }, currentMessage)))));
};
const getDefaultAdHocDataViews = prev => () => [...prev(), {
  id: 'example-root-profile-ad-hoc-data-view',
  name: 'Example profile data view',
  title: 'my-example-*',
  timeFieldName: '@timestamp'
}];