"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorStacktraceLink = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _telemetry = require("../../../../services/telemetry");
var _constants = require("../../../../../common/constants");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ErrorStacktraceLink = ({
  errorType,
  children
}) => {
  const {
    datasetDetails,
    timeRange
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const query = {
    language: 'kuery',
    query: `error.type: "${errorType}"`
  };
  const {
    sendTelemetry
  } = (0, _hooks.useDatasetDetailsRedirectLinkTelemetry)({
    query,
    navigationSource: _telemetry.NavigationSource.FailedDocsFlyoutErrorsTable
  });
  const {
    linkProps
  } = (0, _hooks.useRedirectLink)({
    dataStreamStat: datasetDetails,
    query,
    sendTelemetry,
    timeRangeConfig: timeRange,
    selector: _constants.FAILURE_STORE_SELECTOR
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement("strong", null, errorType), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    external: true
  }, linkProps, {
    color: "primary",
    "data-test-subj": `datasetQualityTableDetailsLink-${datasetDetails.name}`,
    target: "_blank"
  }), children));
};
exports.ErrorStacktraceLink = ErrorStacktraceLink;