"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QualityIssues = QualityIssues;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../../../common/translations");
var _table = require("./table");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function QualityIssues() {
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: _translations.overviewQualityIssuesSectionTitle
  });
  const toggleTextSwitchId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'toggleTextSwitch'
  });
  const {
    totalItemCount,
    toggleCurrentQualityIssues,
    showCurrentQualityIssues
  } = (0, _hooks.useQualityIssues)();
  const latestBackingIndexToggle = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _translations.currentIssuesToggleSwitch,
    checked: showCurrentQualityIssues,
    onChange: toggleCurrentQualityIssues,
    "aria-describedby": toggleTextSwitchId,
    compressed: true,
    "data-test-subj": "datasetQualityDetailsOverviewDegradedFieldToggleSwitch",
    css: {
      marginRight: '5px'
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _translations.currentIssuesToggleSwitchTooltip,
    position: "top"
  }));
  const accordionTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, _translations.overviewQualityIssuesSectionTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _translations.overviewQualityIssueSectionTitleTooltip,
    color: "subdued",
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default",
    "data-test-subj": "datasetQualityDetailsOverviewDegradedFieldTitleCount"
  }, totalItemCount), /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _translations.overviewQualityIssuesAccordionTechPreviewBadge,
    color: "hollow",
    "data-test-subj": "datasetQualityDetailsOverviewDegradedFieldsTechPreview",
    size: "s"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: accordionTitle,
    paddingSize: "none",
    initialIsOpen: true,
    extraAction: latestBackingIndexToggle,
    "data-test-subj": "datasetQualityDetailsOverviewDocumentTrends"
  }, /*#__PURE__*/_react.default.createElement(_table.QualityIssuesTable, null)));
}