"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultDataVisualizerListState = exports.IndexDataVisualizerView = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _common = require("@kbn/data-plugin/common");
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
var _mlUrlState = require("@kbn/ml-url-state");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _field_types_utils = require("../../../common/util/field_types_utils");
var _storage = require("../../types/storage");
var _stats_table = require("../../../common/components/stats_table");
var _index_based_expanded_row = require("../../../common/components/expanded_row/index_based_expanded_row");
var _index_data_visualizer_viewer = require("../../constants/index_data_visualizer_viewer");
var _kibana_context = require("../../../kibana_context");
var _field_count_panel = require("../../../common/components/field_count_panel");
var _document_count_content = require("../../../common/components/document_count_content");
var _constants = require("../../../../../common/constants");
var _search_panel = require("../search_panel");
var _actions_panel = require("../actions_panel");
var _data_view_management = require("../data_view_management");
var _use_data_visualizer_grid_data = require("../../hooks/use_data_visualizer_grid_data");
var _random_sampler = require("../../constants/random_sampler");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultSearchQuery = {
  match_all: {}
};
const getDefaultDataVisualizerListState = overrides => ({
  pageIndex: 0,
  pageSize: 25,
  sortField: 'fieldName',
  sortDirection: 'asc',
  visibleFieldTypes: [],
  visibleFieldNames: [],
  searchString: '',
  searchQuery: defaultSearchQuery,
  searchQueryLanguage: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY,
  filters: [],
  showDistributions: true,
  showAllFields: false,
  showEmptyFields: false,
  probability: null,
  rndSamplerPref: _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC,
  ...overrides
});
exports.getDefaultDataVisualizerListState = getDefaultDataVisualizerListState;
const IndexDataVisualizerView = dataVisualizerProps => {
  var _dataVisualizerListSt, _dataVisualizerListSt2, _dataVisualizerListSt3, _dataVisualizerListSt5;
  const [savedRandomSamplerPreference, saveRandomSamplerPreference] = (0, _mlLocalStorage.useStorage)(_storage.DV_RANDOM_SAMPLER_PREFERENCE, _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC);
  const [savedRandomSamplerProbability, saveRandomSamplerProbability] = (0, _mlLocalStorage.useStorage)(_storage.DV_RANDOM_SAMPLER_P_VALUE, _random_sampler.MIN_SAMPLER_PROBABILITY);
  const [frozenDataPreference, setFrozenDataPreference] = (0, _mlLocalStorage.useStorage)(_storage.DV_FROZEN_TIER_PREFERENCE,
  // By default we will exclude frozen data tier
  _mlDatePicker.FROZEN_TIER_PREFERENCE.EXCLUDE);
  const restorableDefaults = (0, _react2.useMemo)(() => getDefaultDataVisualizerListState({
    rndSamplerPref: savedRandomSamplerPreference,
    probability: savedRandomSamplerProbability
  }),
  // We just need to load the saved preference when the page is first loaded
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const {
    services
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const {
    uiSettings,
    data
  } = services;
  const [dataVisualizerListState, setDataVisualizerListState] = (0, _mlUrlState.usePageUrlState)(_index_data_visualizer_viewer.DATA_VISUALIZER_INDEX_VIEWER, restorableDefaults);
  const [globalState, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const [currentSavedSearch, setCurrentSavedSearch] = (0, _react2.useState)(dataVisualizerProps.currentSavedSearch);
  const [localQueryString, setLocalQueryString] = (0, _react2.useState)(dataVisualizerListState.searchString);
  const {
    currentDataView,
    currentSessionId,
    getAdditionalLinks
  } = dataVisualizerProps;
  const dataViewFields = currentDataView.fields;
  const fieldTypes = (0, _react2.useMemo)(() => {
    // Obtain the list of non metric field types which appear in the index pattern.
    const indexedFieldTypes = [];
    dataViewFields.forEach(field => {
      if (!_constants.OMIT_FIELDS.includes(field.name) && field.scripted !== true) {
        const dataVisualizerType = (0, _field_types_utils.kbnTypeToSupportedType)(field);
        if (dataVisualizerType !== undefined && !indexedFieldTypes.includes(dataVisualizerType)) {
          indexedFieldTypes.push(dataVisualizerType);
        }
      }
    });
    return indexedFieldTypes.sort();
  }, [dataViewFields]);
  const setSearchParams = (0, _react2.useCallback)(searchParams => {
    // When the user loads saved search and then clears or modifies the query
    // we should remove the saved search and replace it with the index pattern id
    if (currentSavedSearch !== null) {
      setCurrentSavedSearch(null);
    }
    setDataVisualizerListState({
      ...dataVisualizerListState,
      searchQuery: searchParams.searchQuery,
      searchString: searchParams.searchString,
      searchQueryLanguage: searchParams.queryLanguage,
      filters: searchParams.filters
    });
  }, [currentSavedSearch, dataVisualizerListState, setDataVisualizerListState]);
  const visibleFieldTypes = (_dataVisualizerListSt = dataVisualizerListState.visibleFieldTypes) !== null && _dataVisualizerListSt !== void 0 ? _dataVisualizerListSt : restorableDefaults.visibleFieldTypes;
  const setVisibleFieldTypes = values => {
    setDataVisualizerListState({
      ...dataVisualizerListState,
      visibleFieldTypes: values
    });
  };
  const visibleFieldNames = (_dataVisualizerListSt2 = dataVisualizerListState.visibleFieldNames) !== null && _dataVisualizerListSt2 !== void 0 ? _dataVisualizerListSt2 : restorableDefaults.visibleFieldNames;
  const setVisibleFieldNames = values => {
    setDataVisualizerListState({
      ...dataVisualizerListState,
      visibleFieldNames: values
    });
  };
  const showEmptyFields = (_dataVisualizerListSt3 = dataVisualizerListState.showEmptyFields) !== null && _dataVisualizerListSt3 !== void 0 ? _dataVisualizerListSt3 : restorableDefaults.showEmptyFields;
  const toggleShowEmptyFields = () => {
    setDataVisualizerListState({
      ...dataVisualizerListState,
      showEmptyFields: !dataVisualizerListState.showEmptyFields
    });
  };
  const input = (0, _react2.useMemo)(() => {
    return {
      dataView: currentDataView,
      savedSearch: currentSavedSearch,
      sessionId: currentSessionId,
      visibleFieldNames,
      allowEditDataView: true,
      id: _index_data_visualizer_viewer.DATA_VISUALIZER_INDEX_VIEWER_ID
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [currentDataView.id, currentSavedSearch === null || currentSavedSearch === void 0 ? void 0 : currentSavedSearch.id, visibleFieldNames, currentSessionId]);
  const {
    configs,
    searchQueryLanguage,
    searchString,
    overallStats,
    searchQuery,
    documentCountStats,
    metricsStats,
    timefilter,
    setLastRefresh,
    progress,
    extendedColumns,
    overallStatsProgress
  } = (0, _use_data_visualizer_grid_data.useDataVisualizerGridData)(input, dataVisualizerListState, savedRandomSamplerPreference, setGlobalState);
  (0, _react2.useEffect)(() => {
    var _ref, _dataVisualizerListSt4;
    switch (savedRandomSamplerPreference) {
      case _random_sampler.RANDOM_SAMPLER_OPTION.OFF:
        setSamplingProbability(1);
        return;
      case _random_sampler.RANDOM_SAMPLER_OPTION.ON_MANUAL:
        setSamplingProbability((_ref = (_dataVisualizerListSt4 = dataVisualizerListState === null || dataVisualizerListState === void 0 ? void 0 : dataVisualizerListState.probability) !== null && _dataVisualizerListSt4 !== void 0 ? _dataVisualizerListSt4 : documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.probability) !== null && _ref !== void 0 ? _ref : null);
        return;
      case _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC:
      default:
        setSamplingProbability(null);
        return;
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [dataVisualizerListState.probability, documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.probability, savedRandomSamplerPreference]);
  const setSamplingProbability = (0, _react2.useCallback)(value => {
    if (savedRandomSamplerPreference === _random_sampler.RANDOM_SAMPLER_OPTION.ON_MANUAL && value !== null) {
      saveRandomSamplerProbability(value);
    }
    setDataVisualizerListState({
      ...dataVisualizerListState,
      probability: value
    });
  }, [dataVisualizerListState, saveRandomSamplerProbability, savedRandomSamplerPreference, setDataVisualizerListState]);
  const setRandomSamplerPreference = (0, _react2.useCallback)(nextPref => {
    if (nextPref === _random_sampler.RANDOM_SAMPLER_OPTION.ON_MANUAL) {
      // By default, when switching to manual, restore previously chosen probability
      // else, default to 0.001%
      setSamplingProbability(savedRandomSamplerProbability && savedRandomSamplerProbability > 0 && savedRandomSamplerProbability <= 0.5 ? savedRandomSamplerProbability : _random_sampler.MIN_SAMPLER_PROBABILITY);
    }
    saveRandomSamplerPreference(nextPref);
  }, [savedRandomSamplerProbability, setSamplingProbability, saveRandomSamplerPreference]);
  (0, _react2.useEffect)(function clearFiltersOnLeave() {
    return () => {
      // We want to clear all filters that have not been pinned globally
      // when navigating to other pages
      data.query.filterManager.getFilters().filter(f => {
        var _f$$state;
        return ((_f$$state = f.$state) === null || _f$$state === void 0 ? void 0 : _f$$state.store) === _esQuery.FilterStateStore.APP_STATE;
      }).forEach(f => data.query.filterManager.removeFilter(f));
    };
  }, [data.query.filterManager]);
  (0, _react2.useEffect)(() => {
    // Force refresh on index pattern change
    setLastRefresh(Date.now());
  }, [currentDataView.id, setLastRefresh]);
  (0, _react2.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.time) !== undefined) {
      timefilter.setTime({
        from: globalState.time.from,
        to: globalState.time.to
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.time), timefilter]);
  (0, _react2.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined) {
      timefilter.setRefreshInterval(globalState.refreshInterval);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval), timefilter]);
  const onAddFilter = (0, _react2.useCallback)((field, values, operation) => {
    var _data$query$filterMan;
    const newFilters = (0, _public.generateFilters)(data.query.filterManager, field, values, operation, currentDataView);
    if (newFilters) {
      data.query.filterManager.addFilters(newFilters);
    }

    // Merge current query with new filters
    const mergedQuery = {
      query: searchString || '',
      language: searchQueryLanguage
    };
    const combinedQuery = (0, _esQuery.buildEsQuery)(currentDataView, {
      query: searchString || '',
      language: searchQueryLanguage
    }, (_data$query$filterMan = data.query.filterManager.getFilters()) !== null && _data$query$filterMan !== void 0 ? _data$query$filterMan : [], uiSettings ? (0, _common.getEsQueryConfig)(uiSettings) : undefined);
    setSearchParams({
      searchQuery: combinedQuery,
      searchString: mergedQuery.query,
      queryLanguage: mergedQuery.language,
      filters: data.query.filterManager.getFilters()
    });
  }, [currentDataView, data.query.filterManager, searchQueryLanguage, searchString, setSearchParams, uiSettings]);
  const fieldsCountStats = (0, _react2.useMemo)(() => {
    let _visibleFieldsCount = 0;
    let _totalFieldsCount = 0;
    Object.keys(overallStats).forEach(key => {
      const fieldsGroup = overallStats[key];
      if (Array.isArray(fieldsGroup) && fieldsGroup.length > 0) {
        _totalFieldsCount += fieldsGroup.length;
      }
    });
    if (showEmptyFields === true) {
      _visibleFieldsCount = _totalFieldsCount;
    } else {
      _visibleFieldsCount = overallStats.aggregatableExistsFields.length + overallStats.nonAggregatableExistsFields.length;
    }
    return {
      visibleFieldsCount: _visibleFieldsCount,
      totalFieldsCount: _totalFieldsCount
    };
  }, [overallStats, showEmptyFields]);
  const getItemIdToExpandedRowMap = (0, _react2.useCallback)(function (itemIds, items) {
    return itemIds.reduce((m, fieldName) => {
      const item = items.find(fieldVisConfig => fieldVisConfig.fieldName === fieldName);
      if (item !== undefined) {
        m[fieldName] = /*#__PURE__*/_react2.default.createElement(_index_based_expanded_row.IndexBasedDataVisualizerExpandedRow, {
          item: item,
          dataView: currentDataView,
          combinedQuery: {
            searchQueryLanguage,
            searchString
          },
          onAddFilter: onAddFilter,
          totalDocuments: overallStats.totalCount
        });
      }
      return m;
    }, {});
  }, [currentDataView, searchQueryLanguage, searchString, onAddFilter, overallStats.totalCount]);

  // Some actions open up fly-out or popup
  // This variable is used to keep track of them and clean up when unmounting
  const actionFlyoutRef = (0, _react2.useRef)();
  (0, _react2.useEffect)(() => {
    const ref = actionFlyoutRef;
    return () => {
      // Clean up any of the flyout/editor opened from the actions
      if (ref.current) {
        ref.current();
      }
    };
  }, []);
  (0, _react2.useEffect)(() => {
    // Update data query manager if input string is updated
    data === null || data === void 0 ? void 0 : data.query.queryString.setQuery({
      query: searchString,
      language: searchQueryLanguage
    });
  }, [data, searchQueryLanguage, searchString]);
  const hasValidTimeField = (0, _react2.useMemo)(() => currentDataView.timeFieldName !== undefined && currentDataView.timeFieldName !== '', [currentDataView.timeFieldName]);
  const isWithinLargeBreakpoint = (0, _eui.useIsWithinMaxBreakpoint)('l');
  const dvPageHeader = (0, _react.css)({
    [(0, _eui.useEuiBreakpoint)(['xs', 's', 'm', 'l'])]: {
      flexDirection: 'column',
      alignItems: 'flex-start'
    }
  });
  const queryNeedsUpdate = (0, _react2.useMemo)(() => localQueryString !== dataVisualizerListState.searchString ? true : undefined, [dataVisualizerListState.searchString, localQueryString]);
  const onQueryChange = (0, _react2.useCallback)(query => {
    setLocalQueryString(query);
  }, []);
  const handleRefresh = (0, _react2.useCallback)(() => {
    if (queryNeedsUpdate) {
      var _data$query$filterMan2;
      const newQuery = (0, _esQuery.buildEsQuery)(currentDataView, {
        query: localQueryString || '',
        language: searchQueryLanguage
      }, (_data$query$filterMan2 = data.query.filterManager.getFilters()) !== null && _data$query$filterMan2 !== void 0 ? _data$query$filterMan2 : [], uiSettings ? (0, _common.getEsQueryConfig)(uiSettings) : undefined);
      setDataVisualizerListState({
        ...dataVisualizerListState,
        searchString: localQueryString,
        searchQuery: newQuery
      });
    }
  }, [queryNeedsUpdate, currentDataView, localQueryString, searchQueryLanguage, data.query.filterManager, uiSettings, setDataVisualizerListState, dataVisualizerListState]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    restrictWidth: false,
    bottomBorder: false,
    grow: false,
    "data-test-subj": "dataVisualizerIndexPage",
    paddingSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPageTemplate.Section, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPageTemplate.Header, {
    "data-test-subj": "dataVisualizerPageHeader",
    css: dvPageHeader,
    pageTitle: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, currentDataView.getName(), /*#__PURE__*/_react2.default.createElement(_data_view_management.DataVisualizerDataViewManagement, {
      currentDataView: currentDataView
    })),
    rightSideGroupProps: {
      gutterSize: 's',
      'data-test-subj': 'dataVisualizerTimeRangeSelectorSection'
    },
    rightSideItems: [/*#__PURE__*/_react2.default.createElement(_mlDatePicker.DatePickerWrapper, {
      isAutoRefreshOnly: !hasValidTimeField,
      showRefresh: !hasValidTimeField,
      width: "full",
      needsUpdate: queryNeedsUpdate,
      onRefresh: handleRefresh
    }), hasValidTimeField && /*#__PURE__*/_react2.default.createElement(_mlDatePicker.FullTimeRangeSelector, {
      frozenDataPreference: frozenDataPreference,
      setFrozenDataPreference: setFrozenDataPreference,
      dataView: currentDataView,
      query: undefined,
      disabled: false,
      timefilter: timefilter
    })]
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: isWithinLargeBreakpoint ? 'column' : 'row'
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react2.default.createElement(_search_panel.SearchPanel, {
    dataView: currentDataView,
    searchString: searchString,
    searchQuery: searchQuery,
    searchQueryLanguage: searchQueryLanguage,
    setSearchParams: setSearchParams,
    overallStats: overallStats,
    indexedFieldTypes: fieldTypes,
    setVisibleFieldTypes: setVisibleFieldTypes,
    visibleFieldTypes: visibleFieldTypes,
    visibleFieldNames: visibleFieldNames,
    setVisibleFieldNames: setVisibleFieldNames,
    showEmptyFields: showEmptyFields,
    onAddFilter: onAddFilter,
    onQueryChange: onQueryChange
  }), (overallStats === null || overallStats === void 0 ? void 0 : overallStats.totalCount) !== undefined && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, /*#__PURE__*/_react2.default.createElement(_document_count_content.DocumentCountContent, {
    documentCountStats: documentCountStats,
    totalCount: overallStats.totalCount,
    setSamplingProbability: setSamplingProbability,
    samplingProbability: dataVisualizerListState.probability === null ? documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.probability : dataVisualizerListState.probability,
    loading: overallStatsProgress.loaded < 100,
    randomSamplerPreference: savedRandomSamplerPreference,
    setRandomSamplerPreference: setRandomSamplerPreference
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_field_count_panel.FieldCountPanel, {
    showEmptyFields: showEmptyFields,
    toggleShowEmptyFields: toggleShowEmptyFields,
    fieldsCountStats: fieldsCountStats,
    metricsStats: metricsStats
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiProgress, {
    value: progress,
    max: 100,
    size: "xs"
  }), /*#__PURE__*/_react2.default.createElement(_stats_table.DataVisualizerTable, {
    items: configs,
    pageState: dataVisualizerListState,
    updatePageState: setDataVisualizerListState,
    getItemIdToExpandedRowMap: getItemIdToExpandedRowMap,
    extendedColumns: extendedColumns,
    loading: progress < 100,
    overallStatsRunning: overallStatsProgress.isRunning,
    showPreviewByDefault: (_dataVisualizerListSt5 = dataVisualizerListState.showDistributions) !== null && _dataVisualizerListSt5 !== void 0 ? _dataVisualizerListSt5 : true,
    onChange: setDataVisualizerListState,
    totalCount: overallStats.totalCount
  }))), isWithinLargeBreakpoint ? /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }) : null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_actions_panel.ActionsPanel, {
    dataView: currentDataView,
    searchQueryLanguage: searchQueryLanguage,
    searchString: searchString,
    getAdditionalLinks: getAdditionalLinks
  })))));
};
exports.IndexDataVisualizerView = IndexDataVisualizerView;