"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotFoundError = exports.NoPrivilegeMeteringError = exports.NoIndicesMeteringError = exports.AutoOpsError = void 0;
var _errors = require("./common/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable max-classes-per-file */

class NotFoundError extends _errors.DataUsageError {}
exports.NotFoundError = NotFoundError;
class AutoOpsError extends _errors.DataUsageError {}
exports.AutoOpsError = AutoOpsError;
class NoPrivilegeMeteringError extends _errors.DataUsageError {
  constructor() {
    super('You do not have the necessary privileges to access data stream statistics. Please contact your administrator.');
  }
}
exports.NoPrivilegeMeteringError = NoPrivilegeMeteringError;
class NoIndicesMeteringError extends _errors.DataUsageError {
  constructor() {
    super('No data streams or indices are available for the current user. Ensure that the data streams or indices you are authorized to access have been created and contain data. If you believe this is an error, please contact your administrator.');
  }
}
exports.NoIndicesMeteringError = NoIndicesMeteringError;