"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _ui_settings_api = require("./ui_settings_api");
var _ui_settings_client = require("./ui_settings_client");
var _ui_settings_global_client = require("./ui_settings_global_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */
class SettingsService {
  constructor() {
    (0, _defineProperty2.default)(this, "uiSettingsApi", void 0);
    (0, _defineProperty2.default)(this, "uiSettingsClient", void 0);
    (0, _defineProperty2.default)(this, "uiSettingsGlobalClient", void 0);
    (0, _defineProperty2.default)(this, "done$", new _rxjs.Subject());
  }
  setup({
    http,
    injectedMetadata
  }) {
    this.uiSettingsApi = new _ui_settings_api.UiSettingsApi(http);
    http.addLoadingCountSource(this.uiSettingsApi.getLoadingCount$());

    // TODO: Migrate away from legacyMetadata https://github.com/elastic/kibana/issues/22779
    const legacyMetadata = injectedMetadata.getLegacyMetadata();
    this.uiSettingsClient = new _ui_settings_client.UiSettingsClient({
      api: this.uiSettingsApi,
      defaults: legacyMetadata.uiSettings.defaults,
      initialSettings: legacyMetadata.uiSettings.user,
      done$: this.done$
    });
    this.uiSettingsGlobalClient = new _ui_settings_global_client.UiSettingsGlobalClient({
      api: this.uiSettingsApi,
      defaults: legacyMetadata.globalUiSettings.defaults,
      initialSettings: legacyMetadata.globalUiSettings.user,
      done$: this.done$
    });
    return {
      client: this.uiSettingsClient,
      globalClient: this.uiSettingsGlobalClient
    };
  }
  start() {
    if (!this.uiSettingsClient || !this.uiSettingsGlobalClient) {
      throw new Error('#setup must be called before start');
    }
    return {
      client: this.uiSettingsClient,
      globalClient: this.uiSettingsGlobalClient
    };
  }
  stop() {
    this.done$.complete();
    if (this.uiSettingsApi) {
      this.uiSettingsApi.stop();
    }
  }
}
exports.SettingsService = SettingsService;