"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cell = require("./cell");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeaderRow = ({
  columns,
  leftAction,
  spacingForRowIdentifier = false
}) => {
  // Calculate column index offset based on presence of leftAction and rowIdentifier
  const columnIndexOffset = (leftAction ? 1 : 0) + (spacingForRowIdentifier ? 1 : 0);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "reorderableTableHeader",
    role: "rowgroup"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    role: "row",
    "aria-rowindex": 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, leftAction && /*#__PURE__*/_react.default.createElement(_cell.Cell, (0, _extends2.default)({}, _constants.DRAGGABLE_UX_STYLE, {
    role: "columnheader",
    ariaColindex: 1
  }), leftAction), spacingForRowIdentifier && /*#__PURE__*/_react.default.createElement(_cell.Cell, (0, _extends2.default)({}, _constants.DRAGGABLE_UX_STYLE, {
    flexBasis: "24px",
    role: "columnheader",
    ariaColindex: leftAction ? 2 : 1
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.contentConnectors.reorderableTable.rowIdentifierScreenReaderOnlyLabel', {
    defaultMessage: 'Row identifier'
  })))), columns.map((column, columnIndex) => /*#__PURE__*/_react.default.createElement(_cell.Cell, (0, _extends2.default)({
    key: `table_header_cell_${columnIndex}`
  }, column, {
    role: "columnheader",
    ariaColindex: columnIndex + columnIndexOffset + 1
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, column.name))))))));
};
exports.HeaderRow = HeaderRow;