"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApiKeyById = exports.GetApiKeyByIdLogic = void 0;
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getApiKeyById = async ({
  id,
  http
}) => {
  const route = `/internal/content_connectors/api_keys/${id}`;
  return await (http === null || http === void 0 ? void 0 : http.get(route));
};
exports.getApiKeyById = getApiKeyById;
const GetApiKeyByIdLogic = exports.GetApiKeyByIdLogic = (0, _create_api_logic.createApiLogic)(['get_api_key_by_id_logic'], getApiKeyById);