"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.History = History;
var _react = _interopRequireWildcard(require("react"));
var _reactWindow = require("react-window");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _main = require("../main");
var _history_empty = require("./history_empty");
var _contexts = require("../../contexts");
var _editor_context = require("../../contexts/editor_context");
var _history_viewer_monaco = require("./history_viewer_monaco");
var _lib = require("../../lib");
var _types = require("../../../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CHILD_ELEMENT_PREFIX = 'historyReq';
const CheckeableCardLabel = ({
  historyItem
}) => {
  const date = (0, _moment.default)(historyItem.time);
  let formattedDate = date.format('MMM D');
  if (date.diff((0, _moment.default)(), 'days') > -7) {
    formattedDate = date.fromNow();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("b", null, historyItem.method, " ", historyItem.endpoint))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, formattedDate)));
};
function History() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      history,
      routeHistory
    }
  } = (0, _contexts.useServicesContext)();
  const dispatch = (0, _editor_context.useEditorActionContext)();
  const {
    settings: readOnlySettings
  } = (0, _editor_context.useEditorReadContext)();
  const [requests, setPastRequests] = (0, _react.useState)(history.getHistory());
  const clearHistory = (0, _react.useCallback)(() => {
    history.clearHistory();
    setPastRequests(history.getHistory());
  }, [history]);
  const [viewingReq, setViewingReq] = (0, _react.useState)(null);
  const isVerticalLayout = (0, _eui.useIsWithinBreakpoints)(['xs', 's', 'm']);
  const initialize = (0, _react.useCallback)(() => {
    const nextSelectedIndex = 0;
    setViewingReq(requests[nextSelectedIndex]);
  }, [requests]);
  const clear = () => {
    clearHistory();
    initialize();
  };
  const restoreRequestFromHistory = (0, _react.useCallback)(restoreMethod => {
    routeHistory === null || routeHistory === void 0 ? void 0 : routeHistory.push(`/console/${_main.SHELL_TAB_ID}`);
    const formattedRequest = (0, _lib.getFormattedRequest)(viewingReq);
    dispatch({
      type: 'setRequestToRestore',
      payload: {
        request: formattedRequest,
        restoreMethod
      }
    });
  }, [viewingReq, dispatch, routeHistory]);
  (0, _react.useEffect)(() => {
    initialize();
  }, [initialize]);
  const Row = (0, _react.useCallback)(({
    data,
    index,
    style
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    key: index,
    "data-test-subj": "historyItemFieldset",
    style: style
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: `${CHILD_ELEMENT_PREFIX}${index}`,
    label: /*#__PURE__*/_react.default.createElement(CheckeableCardLabel, {
      historyItem: data[index]
    }),
    "data-test-subj": `historyItem-${index}`,
    checkableType: "radio",
    checked: viewingReq === data[index],
    onChange: () => {
      setViewingReq(data[index]);
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), [viewingReq, setViewingReq]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "none",
    hasShadow: false,
    borderRadius: "none",
    css: {
      height: '100%'
    },
    "data-test-subj": "consoleHistoryPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    css: {
      height: '100%'
    },
    direction: isVerticalLayout ? 'vertical' : 'horizontal'
  }, (EuiResizablePanel, EuiResizableButton) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: 50,
    minSize: "30%",
    tabIndex: 0,
    borderRadius: "none",
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true,
    color: "subdued",
    css: {
      height: '100%',
      paddingRight: euiTheme.size.s
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    css: {
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.historyPage.pageTitle",
    defaultMessage: "History"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.historyPage.pageDescription",
    defaultMessage: "Revisit and reuse your past queries"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: {
      height: '100%'
    }
  }, requests.length === 0 && /*#__PURE__*/_react.default.createElement(_history_empty.HistoryEmptyPrompt, null), requests.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiAutoSizer, null, ({
    height,
    width
  }) => /*#__PURE__*/_react.default.createElement(_reactWindow.FixedSizeList, {
    height: height,
    itemCount: requests.length,
    itemSize: 62,
    itemData: requests,
    width: width
  }, Row))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued",
    paddingSize: "s",
    css: {
      paddingTop: euiTheme.size.l
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    color: "primary",
    "data-test-subj": "consoleClearHistoryButton",
    onClick: clear
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.historyPage.clearHistoryButtonLabel",
    defaultMessage: "Clear all history"
  })))))), /*#__PURE__*/_react.default.createElement(EuiResizableButton, {
    className: "conApp__resizerButton"
  }), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: 50,
    minSize: "15%",
    tabIndex: 0,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    color: "subdued",
    css: {
      height: '100%'
    },
    borderRadius: "none",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none",
    css: {
      top: 0
    },
    className: "consoleEditorPanel"
  }, /*#__PURE__*/_react.default.createElement(_history_viewer_monaco.HistoryViewer, {
    settings: readOnlySettings,
    req: viewingReq
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    className: "consoleEditorPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "consoleHistoryAddAndRunButton",
    color: "primary",
    iconType: "play",
    disabled: !viewingReq,
    onClick: () => restoreRequestFromHistory(_types.RestoreMethod.RESTORE_AND_EXECUTE)
  }, _i18n.i18n.translate('console.historyPage.addAndRunButtonLabel', {
    defaultMessage: 'Add and run'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "consoleHistoryApplyButton",
    fill: true,
    color: "primary",
    iconType: "plusInCircle",
    disabled: !viewingReq,
    onClick: () => restoreRequestFromHistory(_types.RestoreMethod.RESTORE)
  }, _i18n.i18n.translate('console.historyPage.applyHistoryButtonLabel', {
    defaultMessage: 'Add'
  }))))))))));
}