"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorRangesExtraActions = ColorRangesExtraActions;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _visualizationUtils = require("@kbn/visualization-utils");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _distribute_equally = require("../assets/distribute_equally");
var _color_ranges_context = require("./color_ranges_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function ColorRangesExtraActions({
  dispatch,
  shouldDisableAdd = false,
  shouldDisableReverse = false,
  shouldDisableDistribute = false
}) {
  const {
    dataBounds,
    palettes
  } = (0, _react.useContext)(_color_ranges_context.ColorRangesContext);
  const onAddColorRange = (0, _react.useCallback)(() => {
    dispatch({
      type: 'addColorRange',
      payload: {
        dataBounds,
        palettes
      }
    });
  }, [dataBounds, dispatch, palettes]);
  const onReversePalette = (0, _react.useCallback)(() => {
    dispatch({
      type: 'reversePalette',
      payload: {
        dataBounds,
        palettes
      }
    });
  }, [dispatch, dataBounds, palettes]);
  const onDistributeValues = (0, _react.useCallback)(() => {
    dispatch({
      type: 'distributeEqually',
      payload: {
        dataBounds,
        palettes
      }
    });
  }, [dataBounds, dispatch, palettes]);
  const oneColorRangeWarn = _i18n.i18n.translate('coloring.dynamicColoring.customPalette.oneColorRange', {
    defaultMessage: `Requires more than one color`
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "m",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    tooltipContent: _i18n.i18n.translate('coloring.dynamicColoring.customPalette.maximumStepsApplied', {
      defaultMessage: `You've applied the maximum number of steps`
    }),
    condition: shouldDisableAdd,
    position: "top",
    delay: "regular"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `lnsPalettePanel_dynamicColoring_addColor`,
    iconType: "plusInCircle",
    color: "primary",
    "aria-label": _i18n.i18n.translate('coloring.dynamicColoring.customPalette.addColorAriaLabel', {
      defaultMessage: 'Add color'
    }),
    size: "xs",
    flush: "left",
    disabled: shouldDisableAdd,
    onClick: onAddColorRange
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "coloring.dynamicColoring.customPalette.addColor",
    defaultMessage: "Add color"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    tooltipContent: oneColorRangeWarn,
    condition: shouldDisableReverse,
    position: "top",
    delay: "regular"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `lnsPalettePanel_dynamicColoring_reverseColors`,
    iconType: "sortable",
    color: "primary",
    "aria-label": _i18n.i18n.translate('coloring.dynamicColoring.customPaletteAriaLabel', {
      defaultMessage: 'Reverse colors'
    }),
    size: "xs",
    flush: "left",
    onClick: onReversePalette,
    disabled: shouldDisableReverse
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "coloring.dynamicColoring.customPalette.reverseColors",
    defaultMessage: "Reverse colors"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    tooltipContent: oneColorRangeWarn,
    condition: shouldDisableDistribute,
    position: "top",
    delay: "regular"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `lnsPalettePanel_dynamicColoring_distributeValues`,
    iconType: _distribute_equally.DistributeEquallyIcon,
    color: "primary",
    "aria-label": _i18n.i18n.translate('coloring.dynamicColoring.customPalette.distributeValuesAriaLabel', {
      defaultMessage: 'Distribute values'
    }),
    size: "xs",
    flush: "left",
    disabled: shouldDisableDistribute,
    onClick: onDistributeValues
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "coloring.dynamicColoring.customPalette.distributeValues",
    defaultMessage: "Distribute values"
  })))));
}