"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../common/lib/kibana");
var _use_get_incident_types = require("./use_get_incident_types");
var _use_get_severity = require("./use_get_severity");
var i18n = _interopRequireWildcard(require("./translations"));
var _domain = require("../../../../common/types/domain");
var _card = require("../card");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResilientFieldsComponent = ({
  connector,
  fields
}) => {
  const {
    incidentTypes = null,
    severityCode = null
  } = fields !== null && fields !== void 0 ? fields : {};
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    isLoading: isLoadingIncidentTypesData,
    isFetching: isFetchingIncidentTypesData,
    data: allIncidentTypesData
  } = (0, _use_get_incident_types.useGetIncidentTypes)({
    http,
    connector
  });
  const {
    isLoading: isLoadingSeverityData,
    isFetching: isFetchingSeverityData,
    data: severityData
  } = (0, _use_get_severity.useGetSeverity)({
    http,
    connector
  });
  const isLoadingIncidentTypes = isLoadingIncidentTypesData || isFetchingIncidentTypesData;
  const isLoadingSeverity = isLoadingSeverityData || isFetchingSeverityData;
  const allIncidentTypes = allIncidentTypesData === null || allIncidentTypesData === void 0 ? void 0 : allIncidentTypesData.data;
  const severity = severityData === null || severityData === void 0 ? void 0 : severityData.data;
  const listItems = (0, _react.useMemo)(() => {
    var _severity$find$name, _severity$find;
    return [...(incidentTypes != null && incidentTypes.length > 0 ? [{
      title: i18n.INCIDENT_TYPES_LABEL,
      description: (allIncidentTypes !== null && allIncidentTypes !== void 0 ? allIncidentTypes : []).filter(type => incidentTypes.includes(type.id.toString())).map(type => type.name).join(', ')
    }] : []), ...(severityCode != null && severityCode.length > 0 ? [{
      title: i18n.SEVERITY_LABEL,
      description: (_severity$find$name = severity === null || severity === void 0 ? void 0 : (_severity$find = severity.find(severityObj => severityObj.id.toString() === severityCode)) === null || _severity$find === void 0 ? void 0 : _severity$find.name) !== null && _severity$find$name !== void 0 ? _severity$find$name : ''
    }] : [])];
  }, [incidentTypes, severityCode, allIncidentTypes, severity]);
  return /*#__PURE__*/_react.default.createElement(_card.ConnectorCard, {
    connectorType: _domain.ConnectorTypes.resilient,
    isLoading: isLoadingIncidentTypes || isLoadingSeverity,
    listItems: listItems,
    title: connector.name
  });
};
exports.default = ResilientFieldsComponent;
ResilientFieldsComponent.displayName = 'ResilientFields';
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;