"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteWorkpads = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _canvas_notify_service = require("../../../services/canvas_notify_service");
var _canvas_workpad_service = require("../../../services/canvas_workpad_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDeleteWorkpads = () => {
  return (0, _react.useCallback)(async workpadIds => {
    const workpadService = (0, _canvas_workpad_service.getCanvasWorkpadService)();
    const removedWorkpads = workpadIds.map(async id => {
      try {
        await workpadService.remove(id);
        return {
          id,
          err: null
        };
      } catch (err) {
        return {
          id,
          err
        };
      }
    });
    return Promise.all(removedWorkpads).then(results => {
      const [passes, errored] = results.reduce(([passesArr, errorsArr], result) => {
        if (result.err) {
          errorsArr.push(result.id);
        } else {
          passesArr.push(result.id);
        }
        return [passesArr, errorsArr];
      }, [[], []]);
      const removedIds = workpadIds.filter(id => passes.includes(id));
      if (errored.length > 0) {
        (0, _canvas_notify_service.getCanvasNotifyService)().error(errors.getDeleteFailureErrorMessage());
      }
      return {
        removedIds,
        errored
      };
    });
  }, []);
};
exports.useDeleteWorkpads = useDeleteWorkpads;
const errors = {
  getDeleteFailureErrorMessage: () => _i18n.i18n.translate('xpack.canvas.error.useDeleteWorkpads.deleteFailureErrorMessage', {
    defaultMessage: `Couldn't delete all workpads`
  })
};