"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApiAnalysisGraph = getApiAnalysisGraph;
var _langgraph = require("@langchain/langgraph");
var _paths = require("./paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const graphState = {
  dataStreamName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  pathOptions: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  results: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  suggestedPaths: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  lastExecutedChain: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  }
};
function modelInput({
  state
}) {
  return {
    lastExecutedChain: 'modelInput',
    pathOptions: state.pathOptions,
    dataStreamName: state.dataStreamName
  };
}
function modelOutput({
  state
}) {
  return {
    lastExecutedChain: 'modelOutput',
    results: {
      suggestedPaths: state.suggestedPaths
    }
  };
}
async function getApiAnalysisGraph({
  model
}) {
  const workflow = new _langgraph.StateGraph({
    channels: graphState
  }).addNode('modelInput', state => modelInput({
    state
  })).addNode('handleGetSuggestedPaths', state => (0, _paths.handleGetSuggestedPaths)({
    state,
    model
  })).addNode('modelOutput', state => modelOutput({
    state
  })).addEdge(_langgraph.START, 'modelInput').addEdge('modelInput', 'handleGetSuggestedPaths').addEdge('handleGetSuggestedPaths', 'modelOutput').addEdge('modelOutput', _langgraph.END);
  const compiledApiAnalysisGraph = workflow.compile();
  return compiledApiAnalysisGraph;
}