"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Page", {
  enumerable: true,
  get: function () {
    return _constants.Page;
  }
});
exports.useNavigate = void 0;
var _react = require("react");
var _constants = require("../constants");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// re-export for convenience

const useNavigate = () => {
  const {
    navigateToApp
  } = (0, _use_kibana.useKibana)().services.application;
  const navigateToPage = (0, _react.useCallback)(page => {
    navigateToApp('integrations', {
      path: _constants.PagePath[page]
    });
  }, [navigateToApp]);
  return navigateToPage;
};
exports.useNavigate = useNavigate;