"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observabilityOverviewRouteRepository = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _transactions = require("../../lib/helpers/transactions");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _default_api_types = require("../default_api_types");
var _get_observability_overview_data = require("./get_observability_overview_data");
var _has_data = require("./has_data");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const observabilityOverviewHasDataRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/observability_overview/has_data',
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    return await (0, _has_data.getHasData)({
      indices: apmEventClient.indices,
      apmEventClient
    });
  }
});
const observabilityOverviewRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/observability_overview',
  params: t.type({
    query: t.intersection([_default_api_types.rangeRt, t.type({
      bucketSize: _ioTsUtils.toNumberRt,
      intervalString: t.string
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      bucketSize,
      intervalString,
      start,
      end
    } = resources.params.query;
    const searchAggregatedTransactions = await (0, _transactions.getSearchTransactionsEvents)({
      apmEventClient,
      config: resources.config,
      start,
      end,
      kuery: ''
    });
    return (0, _get_observability_overview_data.getObservabilityOverviewData)({
      apmEventClient,
      start,
      end,
      bucketSize,
      intervalString,
      searchAggregatedTransactions
    });
  }
});
const observabilityOverviewRouteRepository = exports.observabilityOverviewRouteRepository = {
  ...observabilityOverviewRoute,
  ...observabilityOverviewHasDataRoute
};