"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assistantRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _get_random_sampler = require("../../lib/helpers/get_random_sampler");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _get_apm_downstream_dependencies = require("./get_apm_downstream_dependencies");
var _get_apm_timeseries = require("./get_apm_timeseries");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getApmTimeSeriesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/assistant/get_apm_timeseries',
  security: {
    authz: {
      requiredPrivileges: ['apm', 'ai_assistant']
    }
  },
  params: t.type({
    body: _get_apm_timeseries.getApmTimeseriesRt
  }),
  handler: async resources => {
    const body = resources.params.body;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const timeseries = await (0, _get_apm_timeseries.getApmTimeseries)({
      apmEventClient,
      arguments: body
    });
    return {
      content: timeseries.map(series => (0, _lodash.omit)(series, 'data')),
      data: timeseries
    };
  }
});
const getDownstreamDependenciesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/assistant/get_downstream_dependencies',
  params: t.type({
    query: _get_apm_downstream_dependencies.downstreamDependenciesRouteRt
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      params,
      request,
      core
    } = resources;
    const coreStart = await core.start();
    const [apmEventClient, randomSampler] = await Promise.all([(0, _get_apm_event_client.getApmEventClient)(resources), (0, _get_random_sampler.getRandomSampler)({
      coreStart,
      request,
      probability: 1
    })]);
    const {
      query
    } = params;
    return {
      content: await (0, _get_apm_downstream_dependencies.getAssistantDownstreamDependencies)({
        arguments: query,
        apmEventClient,
        randomSampler
      })
    };
  }
});
const assistantRouteRepository = exports.assistantRouteRepository = {
  ...getApmTimeSeriesRoute,
  ...getDownstreamDependenciesRoute
};