"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Onboarding = Onboarding;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _create_call_apm_api = require("../../../services/rest/create_call_apm_api");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _introduction = require("./introduction");
var _instructions_set = require("./instructions_set");
var _serverless_instructions = require("./serverless_instructions");
var _footer = require("./footer");
var _privilege_type = require("../../../../common/privilege_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Onboarding() {
  const [instructions, setInstructions] = (0, _react.useState)([]);
  const [agentApiKey, setAgentApiKey] = (0, _react.useState)({
    apiKey: null,
    error: false
  });
  const [apiKeyLoading, setApiKeyLoading] = (0, _react.useState)(false);
  const [agentStatus, setAgentStatus] = (0, _react.useState)();
  const [agentStatusLoading, setAgentStatusLoading] = (0, _react.useState)(false);
  const {
    services
  } = (0, _public.useKibana)();
  const {
    config
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    docLinks,
    observabilityShared
  } = services;
  const guideLink = (docLinks === null || docLinks === void 0 ? void 0 : docLinks.links.kibana.guide) || 'https://www.elastic.co/guide/en/kibana/current/index.html';
  const baseUrl = (docLinks === null || docLinks === void 0 ? void 0 : docLinks.ELASTIC_WEBSITE_URL) || 'https://www.elastic.co/';
  const createAgentKey = async () => {
    try {
      setApiKeyLoading(true);
      const privileges = [_privilege_type.PrivilegeType.EVENT];
      const {
        agentKey
      } = await (0, _create_call_apm_api.callApmApi)('POST /api/apm/agent_keys 2023-10-31', {
        signal: null,
        params: {
          body: {
            name: `onboarding-${(Math.random() + 1).toString(36).substring(7)}`,
            privileges
          }
        }
      });
      setAgentApiKey({
        apiKey: agentKey.encoded,
        id: agentKey.id,
        error: false
      });
    } catch (error) {
      var _error$body;
      setAgentApiKey({
        apiKey: null,
        error: true,
        errorMessage: ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || error.message
      });
    } finally {
      setApiKeyLoading(false);
    }
  };
  const checkAgentStatus = async () => {
    try {
      setAgentStatusLoading(true);
      const agentStatusCheck = await (0, _create_call_apm_api.callApmApi)('GET /internal/apm/observability_overview/has_data', {
        signal: null
      });
      setAgentStatus(agentStatusCheck.hasData);
    } catch (error) {
      setAgentStatus(false);
    } finally {
      setAgentStatusLoading(false);
    }
  };
  const instructionsExists = instructions.length > 0;
  (0, _react.useEffect)(() => {
    // Here setInstructions will be called based on the condition for serverless, cloud or onPrem
    // right now we will only call the ServerlessInstruction directly
    setInstructions((0, _serverless_instructions.serverlessInstructions)({
      baseUrl,
      config,
      checkAgentStatus,
      agentStatus,
      agentStatusLoading
    }, apiKeyLoading, agentApiKey, createAgentKey));
  }, [agentApiKey, baseUrl, config, apiKeyLoading, agentStatus, agentStatusLoading]);
  const ObservabilityPageTemplate = observabilityShared.navigation.PageTemplate;
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, null, /*#__PURE__*/_react.default.createElement(_introduction.Introduction, {
    isBeta: false,
    guideLink: guideLink
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), instructionsExists && /*#__PURE__*/_react.default.createElement(_instructions_set.InstructionsSet, {
    instructions: instructions
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_footer.Footer, null));
}