"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabStatus = TabStatus;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TabStatus({
  isLoading,
  isOk,
  children,
  ...props
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, props, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": `${props['data-test-subj']}_Badge`
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default"
  }, "-") : isOk ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "green"
  }, "OK") : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning"
  }, "Warning")))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 10,
    "data-test-subj": `${props['data-test-subj']}_Content`
  }, children)));
}