"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceHealthStatus = void 0;
exports.getServiceHealthStatus = getServiceHealthStatus;
exports.getServiceHealthStatusBadgeColor = getServiceHealthStatusBadgeColor;
exports.getServiceHealthStatusColor = getServiceHealthStatusColor;
exports.getServiceHealthStatusLabel = getServiceHealthStatusLabel;
var _i18n = require("@kbn/i18n");
var _anomaly_severity = require("@kbn/ml-anomaly-utils/anomaly_severity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ServiceHealthStatus = exports.ServiceHealthStatus = /*#__PURE__*/function (ServiceHealthStatus) {
  ServiceHealthStatus["healthy"] = "healthy";
  ServiceHealthStatus["critical"] = "critical";
  ServiceHealthStatus["warning"] = "warning";
  ServiceHealthStatus["unknown"] = "unknown";
  return ServiceHealthStatus;
}({});
function getServiceHealthStatus({
  severity
}) {
  switch (severity) {
    case _anomaly_severity.ML_ANOMALY_SEVERITY.CRITICAL:
    case _anomaly_severity.ML_ANOMALY_SEVERITY.MAJOR:
      return ServiceHealthStatus.critical;
    case _anomaly_severity.ML_ANOMALY_SEVERITY.MINOR:
    case _anomaly_severity.ML_ANOMALY_SEVERITY.WARNING:
      return ServiceHealthStatus.warning;
    case _anomaly_severity.ML_ANOMALY_SEVERITY.LOW:
      return ServiceHealthStatus.healthy;
    case _anomaly_severity.ML_ANOMALY_SEVERITY.UNKNOWN:
      return ServiceHealthStatus.unknown;
  }
}
function getServiceHealthStatusColor(euiTheme, status) {
  const isAmsterdam = euiTheme.themeName === 'EUI_THEME_AMSTERDAM';
  switch (status) {
    case ServiceHealthStatus.healthy:
      return isAmsterdam ? euiTheme.colors.vis.euiColorVis0 : euiTheme.colors.severity.success;
    case ServiceHealthStatus.warning:
      return isAmsterdam ? euiTheme.colors.vis.euiColorVis5 : euiTheme.colors.severity.warning;
    case ServiceHealthStatus.critical:
      return isAmsterdam ? euiTheme.colors.vis.euiColorVis9 : euiTheme.colors.severity.danger;
    case ServiceHealthStatus.unknown:
      return euiTheme.colors.mediumShade;
  }
}
function getServiceHealthStatusBadgeColor(euiTheme, status) {
  const isAmsterdam = euiTheme.themeName === 'EUI_THEME_AMSTERDAM';
  switch (status) {
    case ServiceHealthStatus.healthy:
      return isAmsterdam ? euiTheme.colors.vis.euiColorVisBehindText0 : euiTheme.colors.severity.success;
    case ServiceHealthStatus.warning:
      return isAmsterdam ? euiTheme.colors.vis.euiColorVisBehindText5 : euiTheme.colors.severity.warning;
    case ServiceHealthStatus.critical:
      return isAmsterdam ? euiTheme.colors.vis.euiColorVisBehindText9 : euiTheme.colors.severity.risk;
    case ServiceHealthStatus.unknown:
      return euiTheme.colors.mediumShade;
  }
}
function getServiceHealthStatusLabel(status) {
  switch (status) {
    case ServiceHealthStatus.critical:
      return _i18n.i18n.translate('xpack.apm.serviceHealthStatus.critical', {
        defaultMessage: 'Critical'
      });
    case ServiceHealthStatus.warning:
      return _i18n.i18n.translate('xpack.apm.serviceHealthStatus.warning', {
        defaultMessage: 'Warning'
      });
    case ServiceHealthStatus.healthy:
      return _i18n.i18n.translate('xpack.apm.serviceHealthStatus.healthy', {
        defaultMessage: 'Healthy'
      });
    case ServiceHealthStatus.unknown:
      return _i18n.i18n.translate('xpack.apm.serviceHealthStatus.unknown', {
        defaultMessage: 'Unknown'
      });
  }
}