"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateFlapping = void 0;
var _v = require("@kbn/alerting-types/flapping/v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateFlapping = flapping => {
  const {
    look_back_window: lookBackWindow,
    status_change_threshold: statusChangeThreshold
  } = flapping;
  if (lookBackWindow < _v.MIN_LOOK_BACK_WINDOW || lookBackWindow > _v.MAX_LOOK_BACK_WINDOW) {
    return `look back window must be between ${_v.MIN_LOOK_BACK_WINDOW} and ${_v.MAX_LOOK_BACK_WINDOW}`;
  }
  if (statusChangeThreshold < _v.MIN_STATUS_CHANGE_THRESHOLD || statusChangeThreshold > _v.MAX_STATUS_CHANGE_THRESHOLD) {
    return `status change threshold must be between ${_v.MIN_STATUS_CHANGE_THRESHOLD} and ${_v.MAX_STATUS_CHANGE_THRESHOLD}`;
  }
  if (lookBackWindow < statusChangeThreshold) {
    return `lookBackWindow (${lookBackWindow}) must be equal to or greater than statusChangeThreshold (${statusChangeThreshold})`;
  }
};
exports.validateFlapping = validateFlapping;