"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isWindowParameters = void 0;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Time range definition for baseline and deviation to be used by log rate analysis.
 *
 * @export
 * @interface WindowParameters
 * @typedef {WindowParameters}
 */

/**
 * Type guard for WindowParameters
 *
 * @param {unknown} arg - The argument to be checked.
 * @returns {arg is WindowParameters}
 */
const isWindowParameters = arg => (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['baselineMin', 'baselineMax', 'deviationMin', 'deviationMax']) && Object.values(arg).every(d => typeof d === 'number');
exports.isWindowParameters = isWindowParameters;