"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTokensFromBedrockConverseStream = void 0;
var _eventstreamSerdeNode = require("@smithy/eventstream-serde-node");
var _utilUtf = require("@smithy/util-utf8");
var _lodash = require("lodash");
var _promises = require("stream/promises");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTokensFromBedrockConverseStream = async function (responseStream, logger) {
  try {
    const marshaller = new _eventstreamSerdeNode.EventStreamMarshaller({
      utf8Encoder: _utilUtf.toUtf8,
      utf8Decoder: _utilUtf.fromUtf8
    });
    const responseBuffer = [];
    for await (const chunk of marshaller.deserialize(responseStream, _lodash.identity)) {
      if (chunk) {
        responseBuffer.push(chunk);
      }
    }
    try {
      await (0, _promises.finished)(responseStream);
    } catch (e) {
      var _ref, _e$name;
      logger.error('An error occurred while calculating streaming response tokens', (_ref = (_e$name = e.name) !== null && _e$name !== void 0 ? _e$name : e.message) !== null && _ref !== void 0 ? _ref : e.toString());
    }
    const usage = responseBuffer[responseBuffer.length - 1];
    if (usage) {
      const parsedResponse = JSON.parse((0, _utilUtf.toUtf8)(usage.metadata.body));
      return {
        total_tokens: parsedResponse.usage.totalTokens,
        prompt_tokens: parsedResponse.usage.inputTokens,
        completion_tokens: parsedResponse.usage.outputTokens
      };
    }
    return null; // Return the final tokens once the generator finishes
  } catch (e) {
    var _ref2, _e$name2;
    logger.error('Response from Bedrock converse API did not contain usage object', (_ref2 = (_e$name2 = e.name) !== null && _e$name2 !== void 0 ? _e$name2 : e.message) !== null && _ref2 !== void 0 ? _ref2 : e.toString());
    return null;
  }
};
exports.getTokensFromBedrockConverseStream = getTokensFromBedrockConverseStream;