"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toolTipManager = void 0;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Manager utility that ensures only one tooltip is visible at a time
 *
 * UX rationale (primarily for mouse-only users):
 * @see https://github.com/elastic/kibana/issues/144482
 * @see https://github.com/elastic/eui/issues/5883
 */
var ToolTipManager = /*#__PURE__*/_createClass(function ToolTipManager() {
  var _this = this;
  _classCallCheck(this, ToolTipManager);
  // We use a set instead of a single var just in case
  // multiple tooltips are registered via async shenanigans
  _defineProperty(this, "toolTipsToHide", new Set());
  _defineProperty(this, "registerTooltip", function (hideCallback) {
    _this.toolTipsToHide.forEach(function (hide) {
      return hide();
    });
    _this.toolTipsToHide.clear();
    _this.toolTipsToHide.add(hideCallback);
  });
  _defineProperty(this, "deregisterToolTip", function (hideCallback) {
    _this.toolTipsToHide.delete(hideCallback);
  });
});
var toolTipManager = exports.toolTipManager = new ToolTipManager();