"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireWildcard(require("react"));
var _basic_table = require("./basic_table");
var _button = require("../button");
var _health = require("../health");
var _link = require("../link");
var _accessibility = require("../accessibility");
var _services = require("../../services");
var _faker = require("@faker-js/faker");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
var users = [];
for (var i = 0; i < 20; i++) {
  users.push({
    id: i + 1,
    firstName: _faker.faker.person.firstName(),
    lastName: _faker.faker.person.lastName(),
    github: _faker.faker.internet.userName(),
    dateOfBirth: _faker.faker.date.past(),
    online: _faker.faker.datatype.boolean(),
    location: {
      city: _faker.faker.location.city(),
      country: _faker.faker.location.country()
    }
  });
}
var columns = [{
  field: 'firstName',
  name: 'First Name',
  sortable: true,
  truncateText: true,
  mobileOptions: {
    render: function render(user) {
      return (0, _react2.jsx)("span", null, user.firstName, " ", user.lastName);
    },
    header: false,
    truncateText: false,
    enlarge: true,
    width: '100%'
  }
}, {
  field: 'lastName',
  name: 'Last Name',
  truncateText: true,
  mobileOptions: {
    show: false
  }
}, {
  field: 'github',
  name: 'Github',
  render: function render(username) {
    return (0, _react2.jsx)(_link.EuiLink, {
      href: "#",
      target: "_blank"
    }, username);
  }
}, {
  field: 'dateOfBirth',
  name: 'Date of Birth',
  dataType: 'date',
  render: function render(dateOfBirth) {
    return (0, _services.formatDate)(dateOfBirth, 'dobLong');
  },
  sortable: true
}, {
  field: 'location',
  name: 'Location',
  truncateText: true,
  textOnly: true,
  render: function render(location) {
    return "".concat(location.city, ", ").concat(location.country);
  }
}, {
  field: 'online',
  name: 'Online',
  dataType: 'boolean',
  render: function render(online) {
    var color = online ? 'success' : 'danger';
    var label = online ? 'Online' : 'Offline';
    return (0, _react2.jsx)(_health.EuiHealth, {
      color: color
    }, label);
  },
  sortable: true,
  mobileOptions: {
    show: false
  }
}];
describe('EuiTable', function () {
  var BasicTable = function BasicTable() {
    return (0, _react2.jsx)(_basic_table.EuiBasicTable, {
      tableCaption: "Demo of EuiBasicTable",
      columns: columns,
      items: users,
      "data-test-subj": "cy-basic-table"
    });
  };
  describe('Basic table', function () {
    describe('Automated accessibility check', function () {
      it('has zero violations on render', function () {
        cy.viewport(1024, 768); // medium breakpoint
        cy.realMount((0, _react2.jsx)(BasicTable, null));
        cy.get('[data-test-subj="cy-basic-table"]').should('exist');
        cy.checkAxe();
      });
    });
  });
  describe('Mobile basic table', function () {
    describe('Automated accessibility check', function () {
      it('has zero violations on render', function () {
        cy.viewport(375, 667); // small breakpoint
        cy.realMount((0, _react2.jsx)(BasicTable, null));
        cy.get('[data-test-subj="cy-basic-table"]').should('exist');
        cy.checkAxe();
      });
    });
  });
  describe('Expandable rows', function () {
    var ExpandableRowTable = function ExpandableRowTable() {
      var _useState = (0, _react.useState)({}),
        _useState2 = _slicedToArray(_useState, 2),
        itemIdToExpandedRowMap = _useState2[0],
        setItemIdToExpandedRowMap = _useState2[1];
      var toggleDetails = function toggleDetails(user) {
        var itemIdToExpandedRowMapValues = _objectSpread({}, itemIdToExpandedRowMap);
        if (itemIdToExpandedRowMapValues[user.id]) {
          delete itemIdToExpandedRowMapValues[user.id];
        } else {
          itemIdToExpandedRowMapValues[user.id] = (0, _react2.jsx)("div", null, (0, _react2.jsx)("p", null, "Location: ".concat(user.location.city)), (0, _react2.jsx)("p", null, "This person is online."));
        }
        setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
      };
      var columnsWithExpandingRowToggle = [].concat(columns, [{
        align: 'right',
        width: '40px',
        isExpander: true,
        name: (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, "Expand rows")),
        render: function render(user) {
          var itemIdToExpandedRowMapValues = _objectSpread({}, itemIdToExpandedRowMap);
          return (0, _react2.jsx)(_button.EuiButtonIcon, {
            id: user.id.toString(),
            onClick: function onClick() {
              return toggleDetails(user);
            },
            "aria-label": itemIdToExpandedRowMapValues[user.id] ? 'Collapse' : 'Expand',
            iconType: itemIdToExpandedRowMapValues[user.id] ? 'arrowDown' : 'arrowRight'
          });
        }
      }]);
      return (0, _react2.jsx)(_basic_table.EuiBasicTable, {
        tableCaption: "Demo of EuiBasicTable with expanding rows",
        itemIdToExpandedRowMap: itemIdToExpandedRowMap,
        isExpandable: true,
        columns: columnsWithExpandingRowToggle,
        items: users,
        itemId: "id",
        "data-test-subj": "cy-expandable-row-table"
      });
    };
    beforeEach(function () {
      cy.viewport(1024, 768); // medium breakpoint
      cy.realMount((0, _react2.jsx)(ExpandableRowTable, null));
      cy.get('[data-test-subj="cy-expandable-row-table"]').should('exist');
    });
    describe('Automated accessibility check', function () {
      it('has zero violations on render', function () {
        cy.checkAxe();
      });
    });
    describe('Keyboard accessibility', function () {
      it('has zero violations after expanding a row', function () {
        cy.get('button#1').focus();
        cy.realPress('Enter');
        cy.get('tr.euiTableRow-isExpandedRow div.euiTableCellContent').should('exist');
        cy.checkAxe();
      });
    });
  });
});