"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseSslConfig = exports.baseSslSchema = void 0;
// Inspired by https://github.com/elastic/kibana/blob/master/src/core/server/http/ssl_config.ts
var fs_1 = require("fs");
var joi_1 = __importDefault(require("joi"));
exports.baseSslSchema = joi_1.default.object({
    certificate: joi_1.default.string(),
    certificateAuthorities: joi_1.default.array().single().items(joi_1.default.string()).default([]),
    key: joi_1.default.string(),
    keyPassphrase: joi_1.default.string(),
})
    .default()
    .and('certificate', 'key');
var BaseSslConfig = /** @class */ (function () {
    function BaseSslConfig(_a) {
        var e_1, _b;
        var key = _a.key, certificate = _a.certificate, certificateAuthorities = _a.certificateAuthorities, keyPassphrase = _a.keyPassphrase;
        var _this = this;
        var addCAs = function (ca) {
            if (ca && ca.length) {
                _this.certificateAuthorities = __spreadArray(__spreadArray([], __read((_this.certificateAuthorities || [])), false), __read(ca), false);
            }
        };
        if (key && certificate) {
            this.key = readFile(key);
            this.keyPassphrase = keyPassphrase;
            this.certificate = readFile(certificate);
        }
        var ca = certificateAuthorities;
        if (ca) {
            var parsed = [];
            var paths = Array.isArray(ca) ? ca : [ca];
            if (paths.length > 0) {
                try {
                    for (var paths_1 = __values(paths), paths_1_1 = paths_1.next(); !paths_1_1.done; paths_1_1 = paths_1.next()) {
                        var path = paths_1_1.value;
                        parsed.push(readFile(path));
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (paths_1_1 && !paths_1_1.done && (_b = paths_1.return)) _b.call(paths_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                addCAs(parsed);
            }
        }
    }
    return BaseSslConfig;
}());
exports.BaseSslConfig = BaseSslConfig;
var readFile = function (file) {
    return (0, fs_1.readFileSync)(file, 'utf8');
};
//# sourceMappingURL=ssl_config.js.map